/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared;

import com.google.auto.value.AutoValue;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.IncrementingIdGenerator;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.shared.AutoValue_SoyAstCache_VersionedFile;
import com.google.template.soy.soytree.SoyFileNode;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.concurrent.GuardedBy;
import javax.inject.Inject;

public final class SoyAstCache {
    @GuardedBy(value="this")
    private final Map<String, VersionedFile> cache = new HashMap<String, VersionedFile>();
    private final IdGenerator idGenerator = new IncrementingIdGenerator();

    @Inject
    public SoyAstCache() {
    }

    public synchronized void put(String fileName, VersionedFile versionedFile) {
        this.cache.put(fileName, versionedFile.copy());
    }

    public synchronized VersionedFile get(String fileName, SoyFileSupplier.Version version) {
        VersionedFile entry = this.cache.get(fileName);
        if (entry != null) {
            if (entry.version().equals(version)) {
                return entry.copy();
            }
            this.cache.remove(fileName);
        }
        return null;
    }

    public IdGenerator getNodeIdGenerator() {
        return this.idGenerator;
    }

    @AutoValue
    public static abstract class VersionedFile {
        public static VersionedFile of(SoyFileNode file, SoyFileSupplier.Version version) {
            return new AutoValue_SoyAstCache_VersionedFile(file, version);
        }

        VersionedFile() {
        }

        public abstract SoyFileNode file();

        public abstract SoyFileSupplier.Version version();

        private VersionedFile copy() {
            return new AutoValue_SoyAstCache_VersionedFile(this.file().copy(new CopyState()), this.version());
        }
    }
}

