/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.exprtree.VeLiteralNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.plugin.python.restricted.SoyPythonSourceFunction;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.PythonValueFactoryImpl;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.SoyType;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class TranslateToPyExprVisitor
extends AbstractReturningExprNodeVisitor<PyExpr> {
    private static final SoyErrorKind PROTO_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Proto accessors are not supported in pysrc.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind PROTO_INIT_NOT_SUPPORTED = SoyErrorKind.of("Proto init is not supported in pysrc.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_PY_SRC_FUNCTION_NOT_FOUND = SoyErrorKind.of("Failed to find SoyPySrcFunction ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNTYPED_BRACKET_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Bracket access on values of unknown type is not supported in pysrc. The expression should be declared as a list or map.", new SoyErrorKind.StyleAllowance[0]);
    private static final PyExpr ERROR = new PyExpr("raise Exception('Soy compilation failed')", Integer.MAX_VALUE);
    private static final PyExpr NONE = new PyExpr("None", Integer.MAX_VALUE);
    private final LocalVariableStack localVarExprs;
    private final ErrorReporter errorReporter;
    private final PythonValueFactoryImpl pluginValueFactory;

    TranslateToPyExprVisitor(LocalVariableStack localVarExprs, PythonValueFactoryImpl pluginValueFactory, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.pluginValueFactory = pluginValueFactory;
        this.localVarExprs = localVarExprs;
    }

    @Override
    protected PyExpr visitExprRootNode(ExprRootNode node) {
        return (PyExpr)this.visit(node.getRoot());
    }

    @Override
    protected PyExpr visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        return new PyExpr(node.toSourceString(), Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitStringNode(StringNode node) {
        return new PyStringExpr(node.toSourceString());
    }

    @Override
    protected PyExpr visitNullNode(NullNode node) {
        return NONE;
    }

    @Override
    protected PyExpr visitBooleanNode(BooleanNode node) {
        return new PyExpr(node.getValue() ? "True" : "False", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitListLiteralNode(ListLiteralNode node) {
        return PyExprUtils.convertIterableToPyListExpr(node.getChildren().stream().map(n -> (PyExpr)this.visit((ExprNode)n)).collect(Collectors.toList()));
    }

    @Override
    protected PyExpr visitRecordLiteralNode(RecordLiteralNode node) {
        Preconditions.checkArgument((node.numChildren() == node.getKeys().size() ? 1 : 0) != 0);
        LinkedHashMap<PyExpr, PyExpr> dict = new LinkedHashMap<PyExpr, PyExpr>();
        for (int i = 0; i < node.numChildren(); ++i) {
            dict.put(new PyStringExpr("'" + node.getKey(i) + "'"), (PyExpr)this.visit(node.getChild(i)));
        }
        return PyExprUtils.convertMapToOrderedDict(dict);
    }

    @Override
    protected PyExpr visitMapLiteralNode(MapLiteralNode node) {
        Preconditions.checkArgument((node.numChildren() % 2 == 0 ? 1 : 0) != 0);
        LinkedHashMap<PyExpr, PyExpr> dict = new LinkedHashMap<PyExpr, PyExpr>();
        int n = node.numChildren();
        for (int i = 0; i < n; i += 2) {
            ExprNode keyNode = node.getChild(i);
            PyExpr key = (PyExpr)this.visit(keyNode);
            key = new PyFunctionExprBuilder("runtime.check_not_null").addArg(key).asPyExpr();
            ExprNode valueNode = node.getChild(i + 1);
            dict.put(key, (PyExpr)this.visit(valueNode));
        }
        return PyExprUtils.convertMapToPyExpr(dict);
    }

    @Override
    protected PyExpr visitVarRefNode(VarRefNode node) {
        return this.visitNullSafeNode(node);
    }

    @Override
    protected PyExpr visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node);
    }

    private PyExpr visitNullSafeNode(ExprNode node) {
        StringBuilder nullSafetyPrefix = new StringBuilder();
        String refText = this.visitNullSafeNodeRecurse(node, nullSafetyPrefix);
        if (nullSafetyPrefix.length() == 0) {
            return new PyExpr(refText, Integer.MAX_VALUE);
        }
        return new PyExpr(nullSafetyPrefix + refText, PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL));
    }

    private String visitNullSafeNodeRecurse(ExprNode node, StringBuilder nullSafetyPrefix) {
        switch (node.getKind()) {
            case VAR_REF_NODE: {
                VarRefNode varRef = (VarRefNode)node;
                if (varRef.getDefnDecl().kind() == VarDefn.Kind.STATE) {
                    throw new AssertionError();
                }
                if (varRef.isInjected()) {
                    return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess("ijData", varRef.getName());
                }
                PyExpr translation = this.localVarExprs.getVariableExpression(varRef.getName());
                if (translation != null) {
                    return translation.getText();
                }
                NotFoundBehavior notFoundBehavior = NotFoundBehavior.throwException();
                if (varRef.getDefnDecl().kind() == VarDefn.Kind.PARAM && ((TemplateParam)varRef.getDefnDecl()).hasDefault()) {
                    PyExpr defaultValue = new PyExpr(this.visitNullSafeNodeRecurse(((TemplateParam)varRef.getDefnDecl()).defaultValue(), nullSafetyPrefix), Integer.MAX_VALUE);
                    notFoundBehavior = NotFoundBehavior.defaultValue(defaultValue);
                }
                return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess("data", varRef.getName(), notFoundBehavior);
            }
            case FIELD_ACCESS_NODE: 
            case ITEM_ACCESS_NODE: {
                DataAccessNode dataAccess = (DataAccessNode)node;
                String refText = this.visitNullSafeNodeRecurse(dataAccess.getBaseExprChild(), nullSafetyPrefix);
                if (dataAccess.isNullSafe()) {
                    nullSafetyPrefix.append("None if ").append(refText).append(" is None else ");
                }
                if (node.getKind() == ExprNode.Kind.FIELD_ACCESS_NODE) {
                    FieldAccessNode fieldAccess = (FieldAccessNode)node;
                    return this.genCodeForFieldAccess(fieldAccess, fieldAccess.getBaseExprChild().getType(), refText, fieldAccess.getFieldName());
                }
                ItemAccessNode itemAccess = (ItemAccessNode)node;
                SoyType.Kind baseKind = itemAccess.getBaseExprChild().getType().getKind();
                PyExpr keyPyExpr = (PyExpr)this.visit(itemAccess.getKeyExprChild());
                switch (baseKind) {
                    case LIST: {
                        return TranslateToPyExprVisitor.genCodeForKeyAccess(refText, keyPyExpr, NotFoundBehavior.returnNone());
                    }
                    case UNKNOWN: {
                        this.errorReporter.report(itemAccess.getKeyExprChild().getSourceLocation(), UNTYPED_BRACKET_ACCESS_NOT_SUPPORTED, new Object[0]);
                    }
                    case MAP: 
                    case UNION: {
                        return TranslateToPyExprVisitor.genCodeForKeyAccess(refText, keyPyExpr, NotFoundBehavior.returnNone());
                    }
                    case LEGACY_OBJECT_MAP: 
                    case RECORD: {
                        return TranslateToPyExprVisitor.genCodeForKeyAccess(refText, keyPyExpr, NotFoundBehavior.throwException());
                    }
                }
                throw new AssertionError((Object)("illegal item access on " + (Object)((Object)baseKind)));
            }
        }
        PyExpr value = (PyExpr)this.visit(node);
        return PyExprUtils.maybeProtect(value, Integer.MAX_VALUE).getText();
    }

    @Override
    protected PyExpr visitGlobalNode(GlobalNode node) {
        return (PyExpr)this.visit(node.getValue());
    }

    @Override
    protected PyExpr visitOperatorNode(ExprNode.OperatorNode node) {
        return this.genPyExprUsingSoySyntax(node);
    }

    @Override
    protected PyExpr visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        List children = this.visitChildren(node);
        PyExpr conditionalExpr = PyExprUtils.genPyNotNullCheck((PyExpr)children.get(0));
        PyExpr trueExpr = (PyExpr)children.get(0);
        PyExpr falseExpr = (PyExpr)children.get(1);
        return this.genTernaryConditional(conditionalExpr, trueExpr, falseExpr);
    }

    @Override
    protected PyExpr visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("not runtime.type_safe_eq(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", PyExprUtils.pyPrecedenceForOperator(Operator.NOT));
    }

    @Override
    protected PyExpr visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        List operandPyExprs = this.visitChildren(node);
        return new PyExpr("runtime.type_safe_add(" + ((PyExpr)operandPyExprs.get(0)).getText() + ", " + ((PyExpr)operandPyExprs.get(1)).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    protected PyExpr visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        Operator op = Operator.CONDITIONAL;
        List<Operator.SyntaxElement> syntax = op.getSyntax();
        List operandExprs = this.visitChildren(node);
        Operator.Operand conditionalOperand = (Operator.Operand)syntax.get(0);
        PyExpr conditionalExpr = (PyExpr)operandExprs.get(conditionalOperand.getIndex());
        Operator.Operand trueOperand = (Operator.Operand)syntax.get(4);
        PyExpr trueExpr = (PyExpr)operandExprs.get(trueOperand.getIndex());
        Operator.Operand falseOperand = (Operator.Operand)syntax.get(8);
        PyExpr falseExpr = (PyExpr)operandExprs.get(falseOperand.getIndex());
        return this.genTernaryConditional(conditionalExpr, trueExpr, falseExpr);
    }

    @Override
    protected PyExpr visitFunctionNode(FunctionNode node) {
        Object soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            return this.visitNonPluginFunction(node, (BuiltinFunction)soyFunction);
        }
        if (soyFunction instanceof SoyPythonSourceFunction) {
            return this.pluginValueFactory.applyFunction(node.getSourceLocation(), node.getFunctionName(), (SoyPythonSourceFunction)soyFunction, this.visitChildren(node));
        }
        if (soyFunction instanceof SoyPySrcFunction) {
            List<PyExpr> args = this.visitChildren(node);
            return ((SoyPySrcFunction)soyFunction).computeForPySrc(args);
        }
        if (soyFunction instanceof LoggingFunction) {
            return new PyStringExpr("'" + ((LoggingFunction)soyFunction).getPlaceholder() + "'");
        }
        this.errorReporter.report(node.getSourceLocation(), SOY_PY_SRC_FUNCTION_NOT_FOUND, node.getFunctionName());
        return ERROR;
    }

    private PyExpr visitNonPluginFunction(FunctionNode node, BuiltinFunction nonpluginFn) {
        switch (nonpluginFn) {
            case IS_FIRST: {
                return this.visitForEachFunction(node, "__isFirst");
            }
            case IS_LAST: {
                return this.visitForEachFunction(node, "__isLast");
            }
            case INDEX: {
                return this.visitForEachFunction(node, "__index");
            }
            case CHECK_NOT_NULL: {
                return this.visitCheckNotNullFunction(node);
            }
            case CSS: {
                return this.visitCssFunction(node);
            }
            case XID: {
                return this.visitXidFunction(node);
            }
            case IS_PRIMARY_MSG_IN_USE: {
                return this.visitIsPrimaryMsgInUseFunction(node);
            }
            case TO_FLOAT: {
                return (PyExpr)this.visit(node.getChild(0));
            }
            case DEBUG_SOY_TEMPLATE_INFO: {
                return new PyExpr("False", Integer.MAX_VALUE);
            }
            case V1_EXPRESSION: {
                throw new UnsupportedOperationException("the v1Expression function can't be used in templates compiled to Python");
            }
            case VE_DATA: {
                return NONE;
            }
            case MSG_WITH_ID: 
            case REMAINDER: {
                throw new AssertionError();
            }
        }
        throw new AssertionError();
    }

    private PyExpr visitForEachFunction(FunctionNode node, String suffix) {
        String varName = ((VarRefNode)node.getChild(0)).getName();
        return this.localVarExprs.getVariableExpression(varName + suffix);
    }

    private PyExpr visitCheckNotNullFunction(FunctionNode node) {
        PyExpr childExpr = (PyExpr)this.visit(node.getChild(0));
        return new PyFunctionExprBuilder("runtime.check_not_null").addArg(childExpr).asPyExpr();
    }

    private PyExpr visitCssFunction(FunctionNode node) {
        return new PyFunctionExprBuilder("runtime.get_css_name").addArgs(this.visitChildren(node)).asPyExpr();
    }

    private PyExpr visitXidFunction(FunctionNode node) {
        return new PyFunctionExprBuilder("runtime.get_xid_name").addArg((PyExpr)this.visit(node.getChild(0))).asPyExpr();
    }

    private PyExpr visitIsPrimaryMsgInUseFunction(FunctionNode node) {
        long primaryMsgId = ((IntegerNode)node.getChild(1)).getValue();
        long fallbackMsgId = ((IntegerNode)node.getChild(2)).getValue();
        return new PyExpr("translator_impl.is_msg_available(" + primaryMsgId + ") or not " + "translator_impl" + ".is_msg_available(" + fallbackMsgId + ")", PyExprUtils.pyPrecedenceForOperator(Operator.OR));
    }

    private static String genCodeForLiteralKeyAccess(String containerExpr, String key) {
        return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(containerExpr, key, NotFoundBehavior.throwException());
    }

    private static String genCodeForLiteralKeyAccess(String containerExpr, String key, NotFoundBehavior notFoundBehavior) {
        return TranslateToPyExprVisitor.genCodeForKeyAccess(containerExpr, new PyStringExpr("'" + key + "'"), notFoundBehavior);
    }

    private static String genCodeForKeyAccess(String containerExpr, PyExpr key, NotFoundBehavior notFoundBehavior) {
        switch (notFoundBehavior.getType()) {
            case RETURN_NONE: {
                return new PyFunctionExprBuilder("runtime.key_safe_data_access").addArg(new PyExpr(containerExpr, Integer.MAX_VALUE)).addArg(key).build();
            }
            case THROW: {
                return new PyFunctionExprBuilder(containerExpr + ".get").addArg(key).build();
            }
            case DEFAULT_VALUE: {
                return new PyFunctionExprBuilder(containerExpr + ".get").addArg(key).addArg(notFoundBehavior.getDefaultValue()).build();
            }
        }
        throw new AssertionError((Object)notFoundBehavior.getType());
    }

    private String genCodeForFieldAccess(ExprNode node, SoyType baseType, String containerExpr, String fieldName) {
        if (baseType != null && baseType.getKind() == SoyType.Kind.PROTO) {
            this.errorReporter.report(node.getSourceLocation(), PROTO_ACCESS_NOT_SUPPORTED, new Object[0]);
            return ".ERROR";
        }
        return TranslateToPyExprVisitor.genCodeForLiteralKeyAccess(containerExpr, fieldName);
    }

    private PyExpr genPyExprUsingSoySyntax(ExprNode.OperatorNode opNode) {
        List operandPyExprs = this.visitChildren(opNode);
        String newExpr = PyExprUtils.genExprWithNewToken(opNode.getOperator(), operandPyExprs, null);
        return new PyExpr(newExpr, PyExprUtils.pyPrecedenceForOperator(opNode.getOperator()));
    }

    private PyExpr genTernaryConditional(PyExpr conditionalExpr, PyExpr trueExpr, PyExpr falseExpr) {
        int conditionalPrecedence = PyExprUtils.pyPrecedenceForOperator(Operator.CONDITIONAL);
        StringBuilder exprSb = new StringBuilder().append(PyExprUtils.maybeProtect(trueExpr, conditionalPrecedence).getText()).append(" if ").append(PyExprUtils.maybeProtect(conditionalExpr, conditionalPrecedence).getText()).append(" else ").append(PyExprUtils.maybeProtect(falseExpr, conditionalPrecedence).getText());
        return new PyExpr(exprSb.toString(), conditionalPrecedence);
    }

    @Override
    protected PyExpr visitProtoInitNode(ProtoInitNode node) {
        this.errorReporter.report(node.getSourceLocation(), PROTO_INIT_NOT_SUPPORTED, new Object[0]);
        return ERROR;
    }

    @Override
    protected PyExpr visitVeLiteralNode(VeLiteralNode node) {
        return NONE;
    }

    private static class NotFoundBehavior {
        private static final NotFoundBehavior RETURN_NONE = new NotFoundBehavior(Type.RETURN_NONE);
        private static final NotFoundBehavior THROW = new NotFoundBehavior(Type.THROW);
        private final Type type;
        @Nullable
        private final PyExpr defaultValue;

        private static NotFoundBehavior returnNone() {
            return RETURN_NONE;
        }

        private static NotFoundBehavior throwException() {
            return THROW;
        }

        private static NotFoundBehavior defaultValue(PyExpr defaultValue) {
            return new NotFoundBehavior(defaultValue);
        }

        private NotFoundBehavior(Type type) {
            this.type = type;
            this.defaultValue = null;
        }

        private NotFoundBehavior(PyExpr defaultValue) {
            this.type = Type.DEFAULT_VALUE;
            this.defaultValue = (PyExpr)Preconditions.checkNotNull((Object)defaultValue);
        }

        private Type getType() {
            return this.type;
        }

        private PyExpr getDefaultValue() {
            return this.defaultValue;
        }

        private static enum Type {
            RETURN_NONE,
            THROW,
            DEFAULT_VALUE;

        }
    }
}

