/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.plugin.java.internal;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.plugin.java.internal.AutoValue_PluginAnalyzer_PluginMetadata;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class PluginAnalyzer {
    private PluginAnalyzer() {
    }

    public static PluginMetadata analyze(SoyJavaSourceFunction ssf) {
        FinderFactory factory = new FinderFactory();
        FinderContext context = new FinderContext();
        SoyFunctionSignature fnSig = ssf.getClass().getAnnotation(SoyFunctionSignature.class);
        for (Signature sig : fnSig.value()) {
            List<JavaValue> args = Collections.nCopies(sig.parameterTypes().length, FinderValue.INSTANCE);
            ssf.applyForJavaSource(factory, args, context);
        }
        return PluginMetadata.create(context.accessed, factory.instances);
    }

    public static PluginMetadata analyze(SoyJavaSourceFunction ssf, int argCount) {
        FinderFactory factory = new FinderFactory();
        FinderContext context = new FinderContext();
        List<JavaValue> args = Collections.nCopies(argCount, FinderValue.INSTANCE);
        ssf.applyForJavaSource(factory, args, context);
        return PluginMetadata.create(context.accessed, factory.instances);
    }

    private static final class FinderValue
    implements JavaValue {
        static final FinderValue INSTANCE = new FinderValue();

        private FinderValue() {
        }

        @Override
        public JavaValue isNonNull() {
            return this;
        }

        @Override
        public JavaValue isNull() {
            return this;
        }

        @Override
        public JavaValue asSoyBoolean() {
            return this;
        }

        @Override
        public JavaValue asSoyString() {
            return this;
        }

        @Override
        public JavaValue asSoyInt() {
            return this;
        }

        @Override
        public JavaValue asSoyFloat() {
            return this;
        }

        @Override
        public JavaValue coerceToSoyBoolean() {
            return this;
        }

        @Override
        public JavaValue coerceToSoyString() {
            return this;
        }
    }

    private static final class FinderContext
    implements JavaPluginContext {
        boolean accessed;

        private FinderContext() {
        }

        @Override
        public JavaValue getBidiDir() {
            this.accessed = true;
            return FinderValue.INSTANCE;
        }

        @Override
        public JavaValue getULocale() {
            this.accessed = true;
            return FinderValue.INSTANCE;
        }

        @Override
        public JavaValue getAllRequiredCssNamespaces(JavaValue template) {
            this.accessed = true;
            return FinderValue.INSTANCE;
        }
    }

    private static class FinderFactory
    extends JavaValueFactory {
        Set<Class<?>> instances = new LinkedHashSet();

        private FinderFactory() {
        }

        @Override
        public FinderValue callInstanceMethod(Method method, JavaValue ... params) {
            this.instances.add(method.getDeclaringClass());
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue callStaticMethod(Method method, JavaValue ... params) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue listOf(List<JavaValue> args) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constant(boolean value) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constant(double value) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constant(long value) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constant(String value) {
            return FinderValue.INSTANCE;
        }

        @Override
        public FinderValue constantNull() {
            return FinderValue.INSTANCE;
        }
    }

    @AutoValue
    public static abstract class PluginMetadata {
        static PluginMetadata create(boolean accessesContext, Iterable<Class<?>> pluginInstances) {
            return new AutoValue_PluginAnalyzer_PluginMetadata(accessesContext, ImmutableSet.copyOf(pluginInstances));
        }

        public abstract boolean accessesContext();

        public abstract ImmutableSet<Class<?>> pluginInstances();
    }
}

