/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class XidPass
extends CompilerFilePass {
    private static final SoyErrorKind STRING_OR_GLOBAL_REQUIRED = SoyErrorKind.of("Argument to function ''xid'' must be a string literal or a (possibly) dotted identifier.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind GLOBAL_XID_ARG_IS_RESOLVED = SoyErrorKind.of("The identifier passed to ''xid'' resolves to a global of type ''{0}'' with the value ''{1}''. Identifiers passed to ''xid'' should not collide with registered globals.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter reporter;

    XidPass(ErrorReporter reporter) {
        this.reporter = reporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        block4: for (FunctionNode fn : SoyTreeUtils.getAllFunctionInvocations(file, BuiltinFunction.XID)) {
            if (fn.numChildren() != 1) continue;
            ExprNode child = fn.getChild(0);
            switch (child.getKind()) {
                case GLOBAL_NODE: {
                    GlobalNode global = (GlobalNode)child;
                    if (global.isResolved()) {
                        this.reporter.report(global.getSourceLocation(), GLOBAL_XID_ARG_IS_RESOLVED, global.getType().toString(), global.getValue().toSourceString());
                    }
                    fn.replaceChild(0, (ExprNode)new StringNode(global.getName(), QuoteStyle.SINGLE, global.getSourceLocation()));
                    continue block4;
                }
                case STRING_NODE: {
                    continue block4;
                }
            }
            this.reporter.report(child.getSourceLocation(), STRING_OR_GLOBAL_REQUIRED, new Object[0]);
        }
    }
}

