/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.htmlmatcher.ActiveEdge;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherAccumulatorNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherBlockNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherConditionNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraph;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherGraphNode;
import com.google.template.soy.passes.htmlmatcher.HtmlMatcherTagNode;
import com.google.template.soy.passes.htmlmatcher.HtmlTagMatchingPass;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.ForIfemptyNode;
import com.google.template.soy.soytree.ForNonemptyNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;

public final class StrictHtmlValidationPass
extends CompilerFilePass {
    private static final SoyErrorKind VELOG_NODE_FIRST_CHILD_NOT_TAG = SoyErrorKind.of("The first child of '{velog'} must be a HTML open tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VELOG_NODE_LAST_CHILD_NOT_TAG = SoyErrorKind.of("The last child of '{velog'} must be a HTML close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VELOG_NODE_EXACTLY_ONE_TAG = SoyErrorKind.of("'{velog'} must contain exactly one top-level HTML element.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;
    @Nullable
    private HtmlMatcherGraph htmlMatcherGraph = null;

    public StrictHtmlValidationPass(ErrorReporter errorReporter) {
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter, (Object)"errorReporter must be non-null.");
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode node : file.getChildren()) {
            this.checkTemplateNode(node, nodeIdGen);
        }
    }

    private void checkTemplateNode(TemplateNode node, IdGenerator idGenerator) {
        if (node.isStrictHtml()) {
            this.htmlMatcherGraph = new HtmlTagVisitor(idGenerator, this.errorReporter).exec(node);
            new HtmlTagMatchingPass(this.errorReporter, idGenerator, false, false, null).run(this.htmlMatcherGraph);
            for (VeLogNode veNode : SoyTreeUtils.getAllNodesOfType(node, VeLogNode.class)) {
                this.checkVeLogNode(veNode);
            }
        }
    }

    @VisibleForTesting
    public Optional<HtmlMatcherGraph> getHtmlMatcherGraph() {
        return Optional.ofNullable(this.htmlMatcherGraph);
    }

    private void checkVeLogNode(VeLogNode node) {
        if (node.numChildren() == 0) {
            this.errorReporter.report(node.getSourceLocation(), VELOG_NODE_EXACTLY_ONE_TAG, new Object[0]);
            return;
        }
        HtmlOpenTagNode firstTag = node.getOpenTagNode();
        if (firstTag == null) {
            this.errorReporter.report(((SoyNode.StandaloneNode)node.getChild(0)).getSourceLocation(), VELOG_NODE_FIRST_CHILD_NOT_TAG, new Object[0]);
            return;
        }
        if (firstTag.isSelfClosing() || firstTag.getTagName().isDefinitelyVoid()) {
            if (node.numChildren() > 1) {
                this.errorReporter.report(((SoyNode.StandaloneNode)node.getChild(0)).getSourceLocation(), VELOG_NODE_EXACTLY_ONE_TAG, new Object[0]);
            }
            return;
        }
        Node lastChild = node.getChild(node.numChildren() - 1);
        HtmlCloseTagNode lastTag = node.getCloseTagNode();
        if (lastTag == null) {
            this.errorReporter.report(lastChild.getSourceLocation(), VELOG_NODE_LAST_CHILD_NOT_TAG, new Object[0]);
            return;
        }
        if (lastTag.getTaggedPairs().size() != 1 || !Objects.equals(lastTag.getTaggedPairs().get(0), firstTag)) {
            this.errorReporter.report(((SoyNode.StandaloneNode)node.getChild(0)).getSourceLocation(), VELOG_NODE_EXACTLY_ONE_TAG, new Object[0]);
        }
    }

    private static final class HtmlTagVisitor
    extends AbstractSoyNodeVisitor<HtmlMatcherGraph> {
        private final HtmlMatcherGraph htmlMatcherGraph = new HtmlMatcherGraph();
        private final ArrayDeque<List<ActiveEdge>> activeEdgeStack = new ArrayDeque();
        private final IdGenerator idGenerator;
        private final ErrorReporter errorReporter;

        HtmlTagVisitor(IdGenerator idGenerator, ErrorReporter errorReporter) {
            this.idGenerator = idGenerator;
            this.errorReporter = errorReporter;
        }

        @Override
        public HtmlMatcherGraph exec(SoyNode node) {
            this.visitChildren((SoyNode.BlockNode)node);
            return this.htmlMatcherGraph;
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            if (node.getTagName().isExcludedOptionalTag()) {
                return;
            }
            this.htmlMatcherGraph.addNode(new HtmlMatcherTagNode(node));
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            if (node.getTagName().isExcludedOptionalTag()) {
                return;
            }
            this.htmlMatcherGraph.addNode(new HtmlMatcherTagNode(node));
        }

        @Override
        protected void visitIfNode(IfNode node) {
            this.enterConditionalContext();
            this.visitChildren(node);
            this.exitConditionalContext();
        }

        @Override
        protected void visitIfCondNode(IfCondNode node) {
            HtmlMatcherConditionNode conditionNode = this.enterConditionBranch(node.getExpr(), node);
            this.visitChildren(node);
            this.exitConditionBranch(conditionNode);
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            this.enterConditionalContext();
            this.visitChildren(node);
            this.exitConditionalContext();
        }

        @Override
        protected void visitSwitchCaseNode(SwitchCaseNode node) {
            for (ExprNode expr : node.getExprList()) {
                HtmlMatcherConditionNode conditionNode = this.enterConditionBranch(expr, node);
                this.visitChildren(node);
                this.exitConditionBranch(conditionNode);
            }
        }

        @Override
        protected void visitMsgNode(MsgNode node) {
            this.htmlMatcherGraph.addNode(new HtmlMatcherBlockNode(new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node), "msg"));
        }

        @Override
        protected void visitMsgPluralCaseNode(MsgPluralCaseNode node) {
            this.htmlMatcherGraph.addNode(new HtmlMatcherBlockNode(new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node), "msg"));
        }

        @Override
        protected void visitMsgPluralDefaultNode(MsgPluralDefaultNode node) {
            this.htmlMatcherGraph.addNode(new HtmlMatcherBlockNode(new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node), "msg"));
        }

        @Override
        protected void visitMsgSelectCaseNode(MsgSelectCaseNode node) {
            this.htmlMatcherGraph.addNode(new HtmlMatcherBlockNode(new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node), "msg"));
        }

        @Override
        protected void visitMsgSelectDefaultNode(MsgSelectDefaultNode node) {
            this.htmlMatcherGraph.addNode(new HtmlMatcherBlockNode(new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node), "msg"));
        }

        @Override
        protected void visitForIfemptyNode(ForIfemptyNode node) {
            this.htmlMatcherGraph.addNode(new HtmlMatcherBlockNode(new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node), "loop"));
        }

        @Override
        protected void visitForNonemptyNode(ForNonemptyNode node) {
            this.htmlMatcherGraph.addNode(new HtmlMatcherBlockNode(new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node), "loop"));
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            HtmlMatcherGraph htmlMatcherGraph = new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node);
            new HtmlTagMatchingPass(this.errorReporter, this.idGenerator, false, false, "let content").run(htmlMatcherGraph);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            HtmlMatcherGraph htmlMatcherGraph = new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node);
            new HtmlTagMatchingPass(this.errorReporter, this.idGenerator, false, false, "call param content").run(htmlMatcherGraph);
        }

        private void enterConditionalContext() {
            this.activeEdgeStack.push(new ArrayList());
        }

        private void exitConditionalContext() {
            List<ActiveEdge> activeEdges = this.activeEdgeStack.pop();
            if (this.htmlMatcherGraph.getNodeAtCursor().isPresent()) {
                HtmlMatcherGraphNode activeNode = this.htmlMatcherGraph.getNodeAtCursor().get();
                activeEdges.add(ActiveEdge.create(activeNode, activeNode.getActiveEdgeKind()));
            }
            HtmlMatcherAccumulatorNode accNode = new HtmlMatcherAccumulatorNode();
            accNode.accumulateActiveEdges((ImmutableList<ActiveEdge>)ImmutableList.copyOf(activeEdges));
            this.htmlMatcherGraph.addNode(accNode);
        }

        private HtmlMatcherConditionNode enterConditionBranch(ExprNode expr, SoyNode node) {
            HtmlMatcherConditionNode conditionNode = new HtmlMatcherConditionNode(node, expr, new HtmlTagVisitor(this.idGenerator, this.errorReporter).exec(node));
            this.htmlMatcherGraph.addNode(conditionNode);
            this.htmlMatcherGraph.saveCursor();
            conditionNode.setActiveEdgeKind(HtmlMatcherGraphNode.EdgeKind.TRUE_EDGE);
            return conditionNode;
        }

        private void exitConditionBranch(HtmlMatcherConditionNode ifConditionNode) {
            if (this.htmlMatcherGraph.getNodeAtCursor().isPresent()) {
                HtmlMatcherGraphNode activeNode = this.htmlMatcherGraph.getNodeAtCursor().get();
                this.activeEdgeStack.peek().add(ActiveEdge.create(activeNode, activeNode.getActiveEdgeKind()));
            }
            ifConditionNode.setActiveEdgeKind(HtmlMatcherGraphNode.EdgeKind.FALSE_EDGE);
            this.htmlMatcherGraph.restoreCursor();
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }
    }
}

