/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateRegistry;

public final class StrictDepsPass
extends CompilerFileSetPass {
    private static final SoyErrorKind CALL_TO_UNDEFINED_TEMPLATE = SoyErrorKind.of("Undefined template ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind CALL_TO_INDIRECT_DEPENDENCY = SoyErrorKind.of("Call is satisfied only by indirect dependency {0}. Add it as a direct dependency.", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;

    public StrictDepsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode file : sourceFiles) {
            for (CallBasicNode node : SoyTreeUtils.getAllNodesOfType(file, CallBasicNode.class)) {
                this.checkBasicCall(node, registry);
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkBasicCall(CallBasicNode node, TemplateRegistry registry) {
        TemplateMetadata callee = registry.getBasicTemplateOrElement(node.getCalleeName());
        if (callee == null) {
            String extraErrorMessage = SoyErrors.getDidYouMeanMessage(registry.getBasicTemplateOrElementNames(), node.getCalleeName());
            this.errorReporter.report(node.getSourceLocation(), CALL_TO_UNDEFINED_TEMPLATE, node.getCalleeName(), extraErrorMessage);
        } else {
            SoyFileKind calleeKind = callee.getSoyFileKind();
            String callerFilePath = node.getSourceLocation().getFilePath();
            String calleeFilePath = callee.getSourceLocation().getFilePath();
            if (calleeKind == SoyFileKind.INDIRECT_DEP) {
                this.errorReporter.report(node.getSourceLocation(), CALL_TO_INDIRECT_DEPENDENCY, calleeFilePath);
            }
        }
    }
}

