/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.HtmlElementMetadataP;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.HtmlTagNode;
import com.google.template.soy.soytree.KeyNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyElementPass
extends CompilerFilePass {
    private static final SoyErrorKind ROOT_HAS_KEY_NODE = SoyErrorKind.of("The root node of Soy elements must not have a key. Instead, consider wrapping the Soy element in a keyed tag node.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ROOT_IS_DYNAMIC_TAG = SoyErrorKind.of("The root node of Soy elements must not be a dynamic HTML tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS = SoyErrorKind.of("Soy element open tags must map to exactly one close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SOY_ELEMENT_EXACTLY_ONE_TAG = SoyErrorKind.of("Soy elements must contain exactly one top-level HTML element (e.g, span, div).", new SoyErrorKind.StyleAllowance[0]);
    private static final ImmutableSet<SoyNode.Kind> ALLOWED_CHILD_NODES = Sets.immutableEnumSet((Enum)SoyNode.Kind.LET_CONTENT_NODE, (Enum[])new SoyNode.Kind[]{SoyNode.Kind.LET_VALUE_NODE, SoyNode.Kind.LOG_NODE});
    private static final String DYNAMIC_ELEMENT_TAG = "?";
    private final ErrorReporter errorReporter;

    SoyElementPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getChildren()) {
            ErrorReporter bufferedErrorReporter = ErrorReporter.create((Map<String, SoyFileSupplier>)ImmutableMap.of());
            boolean foundRootTags = false;
            VeLogNode veLogNode = null;
            HtmlOpenTagNode openTag = null;
            for (int i = 0; i < template.numChildren(); ++i) {
                Node child = template.getChild(i);
                if (ALLOWED_CHILD_NODES.contains((Object)child.getKind())) continue;
                if (!foundRootTags && child instanceof HtmlOpenTagNode) {
                    HtmlTagNode closeTag = SoyElementPass.checkHtmlOpenTag(template, (HtmlOpenTagNode)child, bufferedErrorReporter);
                    if (closeTag == null) break;
                    i = template.getChildIndex(closeTag);
                    foundRootTags = true;
                    openTag = (HtmlOpenTagNode)child;
                    continue;
                }
                if (!foundRootTags && child instanceof VeLogNode) {
                    veLogNode = (VeLogNode)child;
                    HtmlOpenTagNode maybeOpenTagNode = veLogNode.getOpenTagNode();
                    if (maybeOpenTagNode == null) {
                        Preconditions.checkState((boolean)this.errorReporter.hasErrors());
                        continue;
                    }
                    HtmlTagNode closeTag = SoyElementPass.checkHtmlOpenTag(veLogNode, maybeOpenTagNode, bufferedErrorReporter);
                    if (closeTag == null) break;
                    openTag = maybeOpenTagNode;
                    foundRootTags = true;
                    continue;
                }
                bufferedErrorReporter.report(child.getSourceLocation(), SOY_ELEMENT_EXACTLY_ONE_TAG, new Object[0]);
                break;
            }
            if (template instanceof TemplateElementNode) {
                bufferedErrorReporter.copyTo(this.errorReporter);
                if (openTag != null) {
                    openTag.setElementRoot();
                }
            }
            boolean isValid = openTag != null && template.numChildren() > 0 && !bufferedErrorReporter.hasErrors();
            HtmlElementMetadataP.Builder builder = HtmlElementMetadataP.newBuilder();
            if (isValid) {
                builder.setTag(openTag.getTagName().isStatic() ? openTag.getTagName().getStaticTagName() : DYNAMIC_ELEMENT_TAG);
            }
            template.setHtmlElementMetadata(builder.setIsHtmlElement(isValid).setIsVelogged(veLogNode != null).build());
        }
    }

    @Nullable
    private static HtmlTagNode checkHtmlOpenTag(SoyNode.BlockNode parent, HtmlOpenTagNode openTagNode, ErrorReporter errorReporter) {
        SoyElementPass.validateNoKey(openTagNode, errorReporter);
        SoyElementPass.validateNoDynamicTag(openTagNode, errorReporter);
        if (openTagNode.isSelfClosing() || openTagNode.getTagName().isDefinitelyVoid() && openTagNode.getTaggedPairs().isEmpty()) {
            return openTagNode;
        }
        if (openTagNode.getTaggedPairs().isEmpty()) {
            return null;
        }
        if (openTagNode.getTaggedPairs().size() == 1) {
            HtmlTagNode closeTag = openTagNode.getTaggedPairs().get(0);
            if (closeTag.getParent() != parent) {
                errorReporter.report(openTagNode.getSourceLocation(), SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
                return null;
            }
            return closeTag;
        }
        errorReporter.report(openTagNode.getSourceLocation(), SOY_ELEMENT_OPEN_TAG_CLOSE_AMBIGUOUS, new Object[0]);
        return null;
    }

    private static void validateNoKey(HtmlOpenTagNode firstTagNode, ErrorReporter errorReporter) {
        for (SoyNode child : firstTagNode.getChildren()) {
            if (!(child instanceof KeyNode)) continue;
            errorReporter.report(firstTagNode.getSourceLocation(), ROOT_HAS_KEY_NODE, new Object[0]);
        }
    }

    private static void validateNoDynamicTag(HtmlOpenTagNode firstTagNode, ErrorReporter errorReporter) {
        if (!firstTagNode.getTagName().isStatic()) {
            errorReporter.report(firstTagNode.getSourceLocation(), ROOT_IS_DYNAMIC_TAG, new Object[0]);
        }
    }
}

