/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.data.internalutils.InternalValueUtils;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;

final class RewriteGlobalsPass
extends CompilerFilePass {
    private static final SoyErrorKind ENUM_MEMBERSHIP_ERROR = SoyErrorKind.of("''{0}'' is not a member of enum ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private final SoyTypeRegistry typeRegistry;
    private final ImmutableMap<String, PrimitiveData> compileTimeGlobals;
    private final ErrorReporter errorReporter;

    RewriteGlobalsPass(SoyTypeRegistry typeRegistry, ImmutableMap<String, PrimitiveData> compileTimeGlobals, ErrorReporter errorReporter) {
        this.typeRegistry = typeRegistry;
        this.compileTimeGlobals = compileTimeGlobals;
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (GlobalNode global : SoyTreeUtils.getAllNodesOfType(file, GlobalNode.class)) {
            this.resolveGlobal(global);
        }
    }

    private void resolveGlobal(GlobalNode global) {
        String enumTypeName;
        SoyType type;
        String name = global.getName();
        int lastDot = name.lastIndexOf(46);
        if (lastDot > 0 && (type = this.typeRegistry.getType(enumTypeName = name.substring(0, lastDot))) != null && type.getKind() == SoyType.Kind.PROTO_ENUM) {
            SoyProtoEnumType enumType = (SoyProtoEnumType)type;
            String enumMemberName = name.substring(lastDot + 1);
            Integer enumValue = enumType.getValue(enumMemberName);
            if (enumValue != null) {
                global.resolve(enumType, new IntegerNode(enumValue.intValue(), global.getSourceLocation()));
            } else {
                this.errorReporter.report(global.getSourceLocation(), ENUM_MEMBERSHIP_ERROR, enumMemberName, enumTypeName);
            }
            return;
        }
        PrimitiveData value = (PrimitiveData)this.compileTimeGlobals.get((Object)global.getName());
        if (value != null) {
            ExprNode.PrimitiveNode expr = InternalValueUtils.convertPrimitiveDataToExpr(value, global.getSourceLocation());
            global.resolve(expr.getType(), expr);
        }
    }
}

