/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Longs;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.Identifier;
import com.google.template.soy.base.internal.QuoteStyle;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.AbstractExprNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.defn.LocalVar;
import java.util.List;

final class MsgWithIdFunctionPass
extends CompilerFilePass {
    private static final SoyErrorKind MSG_VARIABLE_NOT_IN_SCOPE = SoyErrorKind.of("Function ''{0}'' must take a let variable containing a single msg as its only argument.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private final ErrorReporter errorReporter;

    MsgWithIdFunctionPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        block0: for (FunctionNode fn : SoyTreeUtils.getAllFunctionInvocations(file, BuiltinFunction.MSG_WITH_ID)) {
            if (fn.numChildren() != 1) continue;
            ExprNode msgVariable = fn.getChild(0);
            if (!(msgVariable instanceof VarRefNode)) {
                this.badFunctionCall(fn, " It is not a variable.");
                continue;
            }
            VarDefn defn = ((VarRefNode)msgVariable).getDefnDecl();
            if (!(defn instanceof LocalVar)) {
                this.badFunctionCall(fn, " It is not a let variable.");
                continue;
            }
            SoyNode.LocalVarNode declaringNode = ((LocalVar)defn).declaringNode();
            if (!(declaringNode instanceof LetContentNode)) {
                this.badFunctionCall(fn, " It is not a let.");
                continue;
            }
            LetContentNode letNode = (LetContentNode)declaringNode;
            MsgFallbackGroupNode fallbackGroupNode = null;
            for (SoyNode child : letNode.getChildren()) {
                if (child instanceof RawTextNode && ((RawTextNode)child).getRawText().isEmpty()) continue;
                if (child instanceof MsgFallbackGroupNode) {
                    if (fallbackGroupNode == null) {
                        fallbackGroupNode = (MsgFallbackGroupNode)child;
                        continue;
                    }
                    this.badFunctionCall(fn, " There is more than one msg.");
                    continue block0;
                }
                this.badFunctionCall(fn, " There is a non-msg child of the let.");
                continue block0;
            }
            if (fallbackGroupNode == null) {
                this.badFunctionCall(fn, " There was no msg in the referenced let.");
                continue;
            }
            this.handleMsgIdCall(fn, fallbackGroupNode);
        }
    }

    private void badFunctionCall(FunctionNode fn, String explanation) {
        this.errorReporter.report(fn.getChild(0).getSourceLocation(), MSG_VARIABLE_NOT_IN_SCOPE, fn.getFunctionName(), explanation);
        RecordLiteralNode recordLiteral = new RecordLiteralNode(Identifier.create("record", fn.getSourceLocation()), (Iterable<Identifier>)ImmutableList.of((Object)Identifier.create("id", fn.getSourceLocation()), (Object)Identifier.create("msg", fn.getSourceLocation())), fn.getSourceLocation());
        recordLiteral.addChildren((List<? extends ExprNode>)ImmutableList.of((Object)new StringNode("error", QuoteStyle.SINGLE, fn.getSourceLocation()), (Object)fn.getChild(0).copy(new CopyState())));
        fn.getParent().replaceChild(fn, recordLiteral);
    }

    private void handleMsgIdCall(FunctionNode fn, MsgFallbackGroupNode msgNode) {
        AbstractExprNode msgIdNode;
        long primaryMsgId = MsgUtils.computeMsgIdForDualFormat((MsgNode)msgNode.getChild(0));
        if (msgNode.numChildren() == 1) {
            msgIdNode = this.createMsgIdNode(primaryMsgId, fn.getSourceLocation());
        } else {
            long fallbackMsgId = MsgUtils.computeMsgIdForDualFormat((MsgNode)msgNode.getChild(1));
            OperatorNodes.ConditionalOpNode condOpNode = new OperatorNodes.ConditionalOpNode(fn.getSourceLocation());
            FunctionNode isPrimaryMsgInUse = new FunctionNode(Identifier.create(BuiltinFunction.IS_PRIMARY_MSG_IN_USE.getName(), fn.getSourceLocation()), BuiltinFunction.IS_PRIMARY_MSG_IN_USE, fn.getSourceLocation());
            isPrimaryMsgInUse.addChild(fn.getChild(0).copy(new CopyState()));
            isPrimaryMsgInUse.addChild(new IntegerNode(primaryMsgId, fn.getSourceLocation()));
            isPrimaryMsgInUse.addChild(new IntegerNode(fallbackMsgId, fn.getSourceLocation()));
            condOpNode.addChild(isPrimaryMsgInUse);
            condOpNode.addChild(this.createMsgIdNode(primaryMsgId, fn.getSourceLocation()));
            condOpNode.addChild(this.createMsgIdNode(fallbackMsgId, fn.getSourceLocation()));
            msgIdNode = condOpNode;
        }
        RecordLiteralNode recordLiteral = new RecordLiteralNode(Identifier.create("record", fn.getSourceLocation()), (Iterable<Identifier>)ImmutableList.of((Object)Identifier.create("id", fn.getSourceLocation()), (Object)Identifier.create("msg", fn.getSourceLocation())), fn.getSourceLocation());
        recordLiteral.addChildren((List<? extends ExprNode>)ImmutableList.of((Object)msgIdNode, (Object)fn.getChild(0).copy(new CopyState())));
        fn.getParent().replaceChild(fn, recordLiteral);
    }

    private StringNode createMsgIdNode(long id, SourceLocation location) {
        return new StringNode(MsgWithIdFunctionPass.formatMsgId(id), QuoteStyle.SINGLE, location);
    }

    private static String formatMsgId(long id) {
        return BaseEncoding.base64Url().encode(Longs.toByteArray((long)id));
    }
}

