/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyType;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public final class IndirectParamsCalculator {
    private TemplateRegistry templateRegistry;
    private Set<TransitiveCallSituation> visitedCallSituations;
    private Map<String, TemplateMetadata.Parameter> indirectParams;
    private Multimap<String, TemplateMetadata> paramKeyToCalleesMultimap;
    private Multimap<String, SoyType> indirectParamTypes;
    private boolean mayHaveIndirectParamsInExternalCalls;
    private boolean mayHaveIndirectParamsInExternalDelCalls;

    public IndirectParamsCalculator(TemplateRegistry templateRegistry) {
        this.templateRegistry = (TemplateRegistry)Preconditions.checkNotNull((Object)templateRegistry);
    }

    public IndirectParamsInfo calculateIndirectParams(TemplateMetadata template) {
        this.visitedCallSituations = Sets.newHashSet();
        this.indirectParams = Maps.newHashMap();
        this.paramKeyToCalleesMultimap = HashMultimap.create();
        this.indirectParamTypes = LinkedHashMultimap.create();
        this.mayHaveIndirectParamsInExternalCalls = false;
        this.mayHaveIndirectParamsInExternalDelCalls = false;
        this.visit(template, new HashSet<String>(), new HashSet<TemplateMetadata>());
        return new IndirectParamsInfo((ImmutableSortedMap<String, TemplateMetadata.Parameter>)ImmutableSortedMap.copyOf(this.indirectParams), (ImmutableMultimap<String, TemplateMetadata>)ImmutableMultimap.copyOf(this.paramKeyToCalleesMultimap), (ImmutableMultimap<String, SoyType>)ImmutableMultimap.copyOf(this.indirectParamTypes), this.mayHaveIndirectParamsInExternalCalls, this.mayHaveIndirectParamsInExternalDelCalls);
    }

    private void visit(TemplateMetadata template, Set<String> allCallParamKeys, Set<TemplateMetadata> allCallers) {
        if (!allCallers.add(template)) {
            return;
        }
        for (TemplateMetadata.DataAllCallSituation call : template.getDataAllCallSituations()) {
            Set<String> newAllCallParamKeys = allCallParamKeys;
            if (!allCallParamKeys.containsAll((Collection<?>)call.getExplicitlyPassedParameters())) {
                newAllCallParamKeys = new HashSet<String>();
                newAllCallParamKeys.addAll(allCallParamKeys);
                newAllCallParamKeys.addAll((Collection<String>)call.getExplicitlyPassedParameters());
            }
            if (call.isDelCall()) {
                this.mayHaveIndirectParamsInExternalDelCalls = true;
                for (TemplateMetadata delCallee : this.templateRegistry.getDelTemplateSelector().delTemplateNameToValues().get((Object)call.getTemplateName())) {
                    this.processCall(template, delCallee, newAllCallParamKeys, allCallers);
                }
                continue;
            }
            TemplateMetadata basicCallee = this.templateRegistry.getBasicTemplateOrElement(call.getTemplateName());
            if (basicCallee == null) {
                this.mayHaveIndirectParamsInExternalCalls = true;
                continue;
            }
            this.processCall(template, basicCallee, newAllCallParamKeys, allCallers);
        }
        allCallers.remove(template);
    }

    private void processCall(TemplateMetadata caller, TemplateMetadata callee, Set<String> allCallParamKeys, Set<TemplateMetadata> allCallers) {
        if (caller.equals(callee) || allCallers.contains(callee)) {
            return;
        }
        for (TemplateMetadata.Parameter p : callee.getParameters()) {
            if (allCallParamKeys.contains(p.getName())) continue;
            this.indirectParams.putIfAbsent(p.getName(), p);
            this.indirectParamTypes.put((Object)p.getName(), (Object)p.getType());
            this.paramKeyToCalleesMultimap.put((Object)p.getName(), (Object)callee);
        }
        TransitiveCallSituation transitiveCallSituation = new TransitiveCallSituation(callee, allCallParamKeys);
        if (!this.visitedCallSituations.add(transitiveCallSituation)) {
            return;
        }
        this.visit(callee, allCallParamKeys, allCallers);
    }

    private static final class TransitiveCallSituation {
        private final TemplateMetadata callee;
        private final Set<String> allCallParamKeys;

        public TransitiveCallSituation(TemplateMetadata callee, Set<String> allCallParamKeys) {
            this.callee = callee;
            this.allCallParamKeys = allCallParamKeys;
        }

        public boolean equals(Object other) {
            if (!(other instanceof TransitiveCallSituation)) {
                return false;
            }
            TransitiveCallSituation otherCallSit = (TransitiveCallSituation)other;
            return Objects.equals(otherCallSit.callee, this.callee) && otherCallSit.allCallParamKeys.equals(this.allCallParamKeys);
        }

        public int hashCode() {
            return this.callee.hashCode() * 31 + this.allCallParamKeys.hashCode();
        }
    }

    public static class IndirectParamsInfo {
        public final ImmutableSortedMap<String, TemplateMetadata.Parameter> indirectParams;
        public final ImmutableMultimap<String, TemplateMetadata> paramKeyToCalleesMultimap;
        public final ImmutableMultimap<String, SoyType> indirectParamTypes;
        public final boolean mayHaveIndirectParamsInExternalCalls;
        public final boolean mayHaveIndirectParamsInExternalDelCalls;

        public IndirectParamsInfo(ImmutableSortedMap<String, TemplateMetadata.Parameter> indirectParams, ImmutableMultimap<String, TemplateMetadata> paramKeyToCalleesMultimap, ImmutableMultimap<String, SoyType> indirectParamTypes, boolean mayHaveIndirectParamsInExternalCalls, boolean mayHaveIndirectParamsInExternalDelCalls) {
            this.indirectParams = indirectParams;
            this.paramKeyToCalleesMultimap = paramKeyToCalleesMultimap;
            this.indirectParamTypes = indirectParamTypes;
            this.mayHaveIndirectParamsInExternalCalls = mayHaveIndirectParamsInExternalCalls;
            this.mayHaveIndirectParamsInExternalDelCalls = mayHaveIndirectParamsInExternalDelCalls;
        }
    }
}

