/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.soytree.SkipNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateNode;

final class DesugarSkipNodesPass
extends CompilerFilePass {
    private static final SoyErrorKind SKIP_NOT_NOT_IMPLEMENTED = SoyErrorKind.of("Skip nodes have not been implemented yet.", new SoyErrorKind.StyleAllowance[0]);
    private final boolean enableSkipNode;
    private final ErrorReporter errorReporter;

    public DesugarSkipNodesPass(boolean enableSkipNode, ErrorReporter errorReporter) {
        this.enableSkipNode = enableSkipNode;
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode template : file.getChildren()) {
            for (SkipNode skipNode : SoyTreeUtils.getAllNodesOfType(template, SkipNode.class)) {
                if (!this.enableSkipNode) {
                    this.errorReporter.report(skipNode.getSourceLocation(), SKIP_NOT_NOT_IMPLEMENTED, new Object[0]);
                }
                skipNode.getParent().removeChild(skipNode);
            }
        }
    }
}

