/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.VarDefn;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateStateVar;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

final class CheckTemplateHeaderVarsPass
extends CompilerFileSetPass {
    private static final SoyErrorKind UNDECLARED_DATA_KEY = SoyErrorKind.of("Unknown data key ''{0}''.{1}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNUSED_VAR = SoyErrorKind.of("''{0}'' unused in template body.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckTemplateHeaderVarsPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        for (SoyFileNode fileNode : sourceFiles) {
            for (TemplateNode templateNode : fileNode.getChildren()) {
                this.checkTemplate(templateNode, registry);
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkTemplate(TemplateNode node, TemplateRegistry templateRegistry) {
        ArrayListMultimap dataKeys = ArrayListMultimap.create();
        for (VarRefNode varRefNode : SoyTreeUtils.getAllNodesOfType(node, VarRefNode.class)) {
            if (!varRefNode.isPossibleHeaderVar().booleanValue()) continue;
            dataKeys.put((Object)varRefNode.getName(), (Object)varRefNode.getSourceLocation());
        }
        if (node instanceof TemplateElementNode) {
            TemplateElementNode el = (TemplateElementNode)node;
            for (TemplateStateVar state : el.getStateVars()) {
                for (VarRefNode varRefNode : SoyTreeUtils.getAllNodesOfType(state.defaultValue(), VarRefNode.class)) {
                    if (varRefNode.getDefnDecl().kind() == VarDefn.Kind.UNDECLARED) {
                        this.errorReporter.report(varRefNode.getSourceLocation(), UNDECLARED_DATA_KEY, varRefNode.getDefnDecl().name(), "");
                        continue;
                    }
                    if (!varRefNode.isPossibleHeaderVar().booleanValue()) continue;
                    dataKeys.put((Object)varRefNode.getName(), (Object)varRefNode.getSourceLocation());
                }
            }
        }
        IndirectParamsCalculator.IndirectParamsInfo ipi = new IndirectParamsCalculator(templateRegistry).calculateIndirectParams(templateRegistry.getMetadata(node));
        HashSet<String> allHeaderVarNames = new HashSet<String>();
        ArrayList<TemplateHeaderVarDefn> unusedParams = new ArrayList<TemplateHeaderVarDefn>();
        for (TemplateHeaderVarDefn param : node.getAllParams()) {
            allHeaderVarNames.add(param.name());
            if (dataKeys.containsKey((Object)param.name())) {
                dataKeys.removeAll((Object)param.name());
                continue;
            }
            if (ipi.paramKeyToCalleesMultimap.containsKey((Object)param.name()) || ipi.mayHaveIndirectParamsInExternalCalls || ipi.mayHaveIndirectParamsInExternalDelCalls) continue;
            unusedParams.add(param);
        }
        ArrayList<TemplateHeaderVarDefn> unusedStateVars = new ArrayList<TemplateHeaderVarDefn>();
        if (node instanceof TemplateElementNode) {
            TemplateElementNode el = (TemplateElementNode)node;
            for (TemplateStateVar stateVar : el.getStateVars()) {
                allHeaderVarNames.add(stateVar.name());
                if (dataKeys.containsKey((Object)stateVar.name())) {
                    dataKeys.removeAll((Object)stateVar.name());
                    continue;
                }
                unusedStateVars.add(stateVar);
            }
        }
        for (Map.Entry undeclared : dataKeys.entries()) {
            String extraErrorMessage = SoyErrors.getDidYouMeanMessage(allHeaderVarNames, (String)undeclared.getKey());
            this.errorReporter.report((SourceLocation)undeclared.getValue(), UNDECLARED_DATA_KEY, undeclared.getKey(), extraErrorMessage);
        }
        if (node instanceof TemplateBasicNode) {
            CheckTemplateHeaderVarsPass.reportUnusedHeaderVars(this.errorReporter, unusedParams, UNUSED_VAR);
        }
        if (node instanceof TemplateElementNode) {
            CheckTemplateHeaderVarsPass.reportUnusedHeaderVars(this.errorReporter, unusedStateVars, UNUSED_VAR);
        }
    }

    private static void reportUnusedHeaderVars(ErrorReporter errorReporter, List<TemplateHeaderVarDefn> unusedHeaderVars, SoyErrorKind soyError) {
        for (TemplateHeaderVarDefn unusedVar : unusedHeaderVars) {
            errorReporter.report(unusedVar.nameLocation(), soyError, unusedVar.name());
        }
    }
}

