/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.shared.internal.DelTemplateSelector;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.CallDelegateNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nullable;

final class CheckDelegatesPass
extends CompilerFileSetPass {
    private static final SoyErrorKind CALL_TO_DELTEMPLATE = SoyErrorKind.of("''call'' to delegate template ''{0}'' (expected ''delcall'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CROSS_PACKAGE_DELCALL = SoyErrorKind.of("Found illegal call from ''{0}'' to ''{1}'', which is in a different delegate package.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELCALL_TO_BASIC_TEMPLATE = SoyErrorKind.of("''delcall'' to basic template ''{0}'' (expected ''call'').", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_WITH_DIFFERENT_PARAM_DECLARATIONS = SoyErrorKind.of("Found delegate template with same name ''{0}'' but different param declarations compared to the definition at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRICT_DELTEMPLATES_WITH_DIFFERENT_CONTENT_KIND = SoyErrorKind.of("If one deltemplate has strict autoescaping, all its peers must also be strictly autoescaped with the same content kind: {0} != {1}. Conflicting definition at {2}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DELTEMPLATES_WITH_DIFFERENT_STRICT_HTML_MODE = SoyErrorKind.of("Found delegate template with same name ''{0}'' but different strict html mode compared to the definition at {1}.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    CheckDelegatesPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        this.checkTemplates(registry);
        for (SoyFileNode fileNode : sourceFiles) {
            for (TemplateNode template : fileNode.getChildren()) {
                String currTemplateNameForUserMsgs = template.getTemplateNameForUserMsgs();
                String currDelPackageName = template.getDelPackageName();
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallBasicNode.class)) {
                    this.checkCallBasicNode((CallBasicNode)callNode, registry, currDelPackageName, currTemplateNameForUserMsgs);
                }
                for (CallNode callNode : SoyTreeUtils.getAllNodesOfType(template, CallDelegateNode.class)) {
                    this.checkCallDelegateNode((CallDelegateNode)callNode, registry);
                }
            }
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }

    private void checkTemplates(TemplateRegistry templateRegistry) {
        DelTemplateSelector<TemplateMetadata> selector = templateRegistry.getDelTemplateSelector();
        for (Collection delTemplateGroup : selector.delTemplateNameToValues().asMap().values()) {
            TemplateMetadata firstDelTemplate = null;
            for (TemplateMetadata delTemplate : delTemplateGroup) {
                if (firstDelTemplate == null) {
                    firstDelTemplate = delTemplate;
                }
                if (delTemplate.getSoyFileKind() != SoyFileKind.SRC) continue;
                firstDelTemplate = delTemplate;
                break;
            }
            if (firstDelTemplate == null) continue;
            Set<TemplateMetadata.Parameter> firstRequiredParamSet = CheckDelegatesPass.getRequiredParamSet(firstDelTemplate);
            SanitizedContentKind firstContentKind = firstDelTemplate.getContentKind();
            boolean firstStrictHtml = firstDelTemplate.isStrictHtml() && firstContentKind == SanitizedContentKind.HTML;
            for (TemplateMetadata delTemplate : delTemplateGroup) {
                if (firstDelTemplate == delTemplate) continue;
                Set<TemplateMetadata.Parameter> currRequiredParamSet = CheckDelegatesPass.getRequiredParamSet(delTemplate);
                if (!currRequiredParamSet.equals(firstRequiredParamSet)) {
                    this.errorReporter.report(firstDelTemplate.getSourceLocation(), DELTEMPLATES_WITH_DIFFERENT_PARAM_DECLARATIONS, delTemplate.getDelTemplateName(), delTemplate.getSourceLocation().toString());
                }
                if (delTemplate.getContentKind() != firstContentKind) {
                    this.errorReporter.report(firstDelTemplate.getSourceLocation(), STRICT_DELTEMPLATES_WITH_DIFFERENT_CONTENT_KIND, String.valueOf((Object)delTemplate.getContentKind()), String.valueOf((Object)firstContentKind), delTemplate.getSourceLocation().toString());
                }
                if (delTemplate.isStrictHtml() == firstStrictHtml) continue;
                this.errorReporter.report(firstDelTemplate.getSourceLocation(), DELTEMPLATES_WITH_DIFFERENT_STRICT_HTML_MODE, delTemplate.getDelTemplateName(), delTemplate.getSourceLocation().toString());
            }
        }
    }

    private static Set<TemplateMetadata.Parameter> getRequiredParamSet(TemplateMetadata delTemplate) {
        HashSet<TemplateMetadata.Parameter> paramSet = new HashSet<TemplateMetadata.Parameter>();
        for (TemplateMetadata.Parameter param : delTemplate.getParameters()) {
            if (!param.isRequired()) continue;
            paramSet.add(param);
        }
        return paramSet;
    }

    private void checkCallBasicNode(CallBasicNode node, TemplateRegistry templateRegistry, @Nullable String currDelPackageName, String currTemplateNameForUserMsgs) {
        String calleeDelPackageName;
        TemplateMetadata callee;
        String calleeName = node.getCalleeName();
        if (templateRegistry.getDelTemplateSelector().hasDelTemplateNamed(calleeName)) {
            this.errorReporter.report(node.getSourceLocation(), CALL_TO_DELTEMPLATE, calleeName);
        }
        if ((callee = templateRegistry.getBasicTemplateOrElement(calleeName)) != null && (calleeDelPackageName = callee.getDelPackageName()) != null && !calleeDelPackageName.equals(currDelPackageName)) {
            if (node.getNearestAncestor(CallParamContentNode.class) == null) {
                this.errorReporter.report(node.getSourceLocation(), CROSS_PACKAGE_DELCALL, currTemplateNameForUserMsgs, callee.getTemplateName());
            } else {
                this.errorReporter.warn(node.getSourceLocation(), CROSS_PACKAGE_DELCALL, currTemplateNameForUserMsgs, callee.getTemplateName());
            }
        }
    }

    private void checkCallDelegateNode(CallDelegateNode node, TemplateRegistry templateRegistry) {
        String delCalleeName = node.getDelCalleeName();
        if (templateRegistry.getBasicTemplateOrElement(delCalleeName) != null) {
            this.errorReporter.report(node.getSourceLocation(), DELCALL_TO_BASIC_TEMPLATE, delCalleeName);
        }
    }
}

