/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateRegistry;

final class AutoescaperPass
extends CompilerFileSetPass {
    private final ContextualAutoescaper autoescaper;
    private final ErrorReporter errorReporter;

    AutoescaperPass(ErrorReporter errorReporter, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives) {
        this.errorReporter = errorReporter;
        this.autoescaper = new ContextualAutoescaper(errorReporter, printDirectives);
    }

    @Override
    public CompilerFileSetPass.Result run(ImmutableList<SoyFileNode> sourceFiles, IdGenerator idGenerator, TemplateRegistry registry) {
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.STOP;
        }
        this.autoescaper.rewrite(sourceFiles, idGenerator, registry);
        if (this.errorReporter.hasErrors()) {
            return CompilerFileSetPass.Result.STOP;
        }
        return CompilerFileSetPass.Result.CONTINUE;
    }
}

