/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import com.google.template.soy.parsepasses.contextautoesc.Context;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.EscapingMode;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateRegistry;
import java.util.List;
import java.util.Map;

final class Inferences {
    private final TemplateRegistry templates;
    private final Map<SoyNode, ImmutableList<EscapingMode>> nodeToEscapingModes = Maps.newIdentityHashMap();
    private final Map<SoyNode, Context> nodeToContext = Maps.newIdentityHashMap();

    public Inferences(TemplateRegistry templates) {
        this.templates = templates;
    }

    ImmutableList<TemplateMetadata> lookupTemplates(CallNode call) {
        return this.templates.getTemplates(call);
    }

    public ImmutableList<EscapingMode> getEscapingMode(PrintNode printNode) {
        ImmutableList<EscapingMode> escapingModes = this.nodeToEscapingModes.get(printNode);
        if (escapingModes != null) {
            return escapingModes;
        }
        ImmutableList.Builder modes = ImmutableList.builder();
        for (PrintDirectiveNode directiveNode : printNode.getChildren()) {
            EscapingMode mode = EscapingMode.fromDirective(directiveNode.getName());
            if (mode == null) continue;
            modes.add((Object)mode);
        }
        return modes.build();
    }

    public void setEscapingDirectives(SoyNode node, Context context, List<EscapingMode> escapingModes) {
        Preconditions.checkArgument((node instanceof PrintNode || node instanceof CallNode || node instanceof MsgFallbackGroupNode ? 1 : 0) != 0, (Object)"Escaping directives may only be set for {print}, {msg}, or {call} nodes");
        if (escapingModes != null) {
            this.nodeToEscapingModes.put(node, (ImmutableList<EscapingMode>)ImmutableList.copyOf(escapingModes));
        }
        this.nodeToContext.put(node, context);
    }

    public ImmutableList<EscapingMode> getEscapingModesForNode(SoyNode node) {
        ImmutableList modes = this.nodeToEscapingModes.get(node);
        if (modes == null) {
            modes = ImmutableList.of();
        }
        return modes;
    }

    @VisibleForTesting
    Context getContextForNode(SoyNode node) {
        return this.nodeToContext.get(node);
    }
}

