/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parseinfo.passes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.CaseFormat;
import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.base.internal.IndentedLinesBuilder;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.parseinfo.SoyFileInfo;
import com.google.template.soy.passes.IndirectParamsCalculator;
import com.google.template.soy.plugin.java.internal.PluginAnalyzer;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateHeaderVarDefn;
import com.google.template.soy.soytree.defn.TemplateParam;
import com.google.template.soy.types.AbstractMapType;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.RecordType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.VeType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class GenerateParseInfoVisitor
extends AbstractSoyNodeVisitor<ImmutableMap<String, String>> {
    private final String javaPackage;
    private final JavaClassNameSource javaClassNameSource;
    private Map<SoyFileNode, String> soyFileToJavaClassNameMap;
    private final TemplateRegistry templateRegistry;
    private final SoyTypeRegistry typeRegistry;
    private final Map<String, String> convertedIdents = Maps.newHashMap();
    private LinkedHashMap<String, String> generatedFiles;
    private IndentedLinesBuilder ilb;

    public GenerateParseInfoVisitor(String javaPackage, String javaClassNameSource, TemplateRegistry registry, SoyTypeRegistry typeRegistry) {
        this.javaPackage = javaPackage;
        this.templateRegistry = registry;
        this.typeRegistry = typeRegistry;
        switch (javaClassNameSource) {
            case "filename": {
                this.javaClassNameSource = JavaClassNameSource.SOY_FILE_NAME;
                break;
            }
            case "namespace": {
                this.javaClassNameSource = JavaClassNameSource.SOY_NAMESPACE_LAST_PART;
                break;
            }
            case "generic": {
                this.javaClassNameSource = JavaClassNameSource.GENERIC;
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid value for javaClassNameSource \"" + javaClassNameSource + "\" (valid values are \"filename\", \"namespace\", and \"generic\").");
            }
        }
    }

    @Override
    public ImmutableMap<String, String> exec(SoyNode node) {
        this.generatedFiles = Maps.newLinkedHashMap();
        this.ilb = null;
        this.visit(node);
        return ImmutableMap.copyOf(this.generatedFiles);
    }

    @Override
    protected void visitSoyFileSetNode(SoyFileSetNode node) {
        HashMultimap baseGeneratedClassNameToSoyFilesMap = HashMultimap.create();
        for (SoyFileNode soyFile : node.getChildren()) {
            baseGeneratedClassNameToSoyFilesMap.put((Object)this.javaClassNameSource.generateBaseClassName(soyFile), (Object)soyFile);
        }
        this.soyFileToJavaClassNameMap = Maps.newHashMap();
        for (String baseClassName : baseGeneratedClassNameToSoyFilesMap.keySet()) {
            Collection soyFiles = baseGeneratedClassNameToSoyFilesMap.get((Object)baseClassName);
            if (soyFiles.size() == 1) {
                for (SoyFileNode soyFile : soyFiles) {
                    this.soyFileToJavaClassNameMap.put(soyFile, baseClassName + "SoyInfo");
                }
                continue;
            }
            int numberSuffix = 1;
            for (SoyFileNode soyFile : soyFiles) {
                this.soyFileToJavaClassNameMap.put(soyFile, baseClassName + numberSuffix + "SoyInfo");
                ++numberSuffix;
            }
        }
        for (SoyFileNode soyFile : node.getChildren()) {
            this.visit(soyFile);
        }
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        String upperUnderscoreKey;
        String javaClassName = this.soyFileToJavaClassNameMap.get(node);
        LinkedHashMap publicBasicTemplateMap = Maps.newLinkedHashMap();
        HashSet allParamKeys = Sets.newHashSet();
        LinkedHashMultimap paramKeyToTemplatesMultimap = LinkedHashMultimap.create();
        TreeSet protoTypes = Sets.newTreeSet();
        TreeMap<String, String> pluginInstances = new TreeMap<String, String>();
        for (Object template : node.getChildren()) {
            if (((TemplateNode)template).getVisibility() == Visibility.PUBLIC && template.getKind() != SoyNode.Kind.TEMPLATE_DELEGATE_NODE) {
                publicBasicTemplateMap.put(this.convertToUpperUnderscore(((TemplateNode)template).getPartialTemplateName().substring(1)), template);
            }
            for (TemplateParam param : ((TemplateNode)template).getParams()) {
                allParamKeys.add(param.name());
                paramKeyToTemplatesMultimap.put((Object)param.name(), template);
            }
            for (TemplateHeaderVarDefn varDefn : ((TemplateNode)template).getHeaderParams()) {
                this.findProtoTypesRecurse(varDefn.type(), protoTypes);
            }
            for (FieldAccessNode fieldAccess : SoyTreeUtils.getAllNodesOfType((Node)template, FieldAccessNode.class)) {
                Descriptors.FieldDescriptor desc;
                SoyType baseType = fieldAccess.getBaseExprChild().getType();
                if (baseType.getKind() != SoyType.Kind.PROTO || !(desc = ((SoyProtoType)baseType).getFieldDescriptor(fieldAccess.getFieldName())).isExtension()) continue;
                protoTypes.add(ProtoUtils.getTofuExtensionImport(desc));
            }
            for (GlobalNode global : SoyTreeUtils.getAllNodesOfType((Node)template, GlobalNode.class)) {
                if (!global.isResolved() || global.getType().getKind() != SoyType.Kind.PROTO_ENUM) continue;
                protoTypes.add(((SoyProtoEnumType)global.getType()).getDescriptorExpression());
            }
            for (ProtoInitNode protoInit : SoyTreeUtils.getAllNodesOfType((Node)template, ProtoInitNode.class)) {
                if (protoInit.getType().getKind() != SoyType.Kind.PROTO) continue;
                protoTypes.add(((SoyProtoType)protoInit.getType()).getDescriptorExpression());
            }
            for (FunctionNode fnNode : SoyTreeUtils.getAllNodesOfType((Node)template, FunctionNode.class)) {
                ImmutableSet<Class<?>> instances;
                if (!(fnNode.getSoyFunction() instanceof SoyJavaSourceFunction) || pluginInstances.containsKey(fnNode.getFunctionName()) || (instances = PluginAnalyzer.analyze((SoyJavaSourceFunction)fnNode.getSoyFunction(), fnNode.numChildren()).pluginInstances()).isEmpty()) continue;
                pluginInstances.put(fnNode.getFunctionName(), ((Class)Iterables.getOnlyElement(instances)).getName());
            }
        }
        TreeMap allParamKeysMap = Maps.newTreeMap();
        for (String key : allParamKeys) {
            upperUnderscoreKey = this.convertToUpperUnderscore(key);
            while (allParamKeysMap.containsKey(upperUnderscoreKey)) {
                upperUnderscoreKey = upperUnderscoreKey + "_";
            }
            allParamKeysMap.put(upperUnderscoreKey, key);
            this.convertedIdents.put(key, upperUnderscoreKey);
        }
        this.ilb = new IndentedLinesBuilder(2);
        this.ilb.appendLine("// This file was automatically generated by the Soy compiler.");
        this.ilb.appendLine("// Please don't edit this file by hand.");
        this.ilb.appendLine("// source: ", node.getFilePath());
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("package ", this.javaPackage, ";");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("import com.google.common.collect.ImmutableList;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableMap;");
        this.ilb.appendLine("import com.google.common.collect.ImmutableSortedSet;");
        if (!protoTypes.isEmpty()) {
            this.ilb.appendLine("import com.google.protobuf.Descriptors.GenericDescriptor;");
        }
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyFileInfo;");
        this.ilb.appendLine("import com.google.template.soy.parseinfo.SoyTemplateInfo;");
        this.ilb.appendLine("import javax.annotation.Generated;");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        GenerateParseInfoVisitor.appendJavadoc(this.ilb, "Soy parse info for " + node.getFileName() + ".", true, false);
        this.ilb.appendLine("@Generated(\"com.google.template.soy.SoyParseInfoGenerator\")");
        this.ilb.appendLine("public final class ", javaClassName, " extends SoyFileInfo {");
        this.ilb.increaseIndent();
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("/** This Soy file's namespace. */");
        this.ilb.appendLine("public static final String __NAMESPACE__ = \"", node.getNamespace(), "\";");
        if (!protoTypes.isEmpty()) {
            this.ilb.appendLine(new Object[0]);
            this.ilb.appendLine(new Object[0]);
            this.ilb.appendLine("/** Protocol buffer types used by these templates. */");
            this.ilb.appendLine("@Override public ImmutableList<GenericDescriptor> getProtoDescriptors() {");
            this.ilb.increaseIndent();
            Iterator defaultInstances = Lists.newArrayList();
            defaultInstances.addAll(protoTypes);
            GenerateParseInfoVisitor.appendListOrSetHelper(this.ilb, "return ImmutableList.<GenericDescriptor>of", (Collection<String>)((Object)defaultInstances));
            this.ilb.appendLineEnd(";");
            this.ilb.decreaseIndent();
            this.ilb.appendLine("}");
        }
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("public static final class TemplateName {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("private TemplateName() {}");
        this.ilb.appendLine(new Object[0]);
        for (Map.Entry templateEntry : publicBasicTemplateMap.entrySet()) {
            StringBuilder javadocSb = new StringBuilder();
            javadocSb.append("The full template name of the ").append(((TemplateNode)templateEntry.getValue()).getPartialTemplateName()).append(" template.");
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, javadocSb.toString(), false, true);
            this.ilb.appendLine("public static final String ", templateEntry.getKey(), " = \"", ((TemplateNode)templateEntry.getValue()).getTemplateName(), "\";");
        }
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("/**");
        this.ilb.appendLine(" * Param names from all templates in this Soy file.");
        this.ilb.appendLine(" */");
        this.ilb.appendLine("public static final class Param {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("private Param() {}");
        this.ilb.appendLine(new Object[0]);
        for (Map.Entry paramEntry : allParamKeysMap.entrySet()) {
            upperUnderscoreKey = (String)paramEntry.getKey();
            String key = (String)paramEntry.getValue();
            StringBuilder javadocSb = new StringBuilder();
            javadocSb.append("Listed by ");
            boolean isFirst = true;
            for (TemplateNode template : paramKeyToTemplatesMultimap.get((Object)key)) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    javadocSb.append(", ");
                }
                javadocSb.append(GenerateParseInfoVisitor.buildTemplateNameForJavadoc(node, this.templateRegistry.getMetadata(template)));
            }
            javadocSb.append('.');
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, javadocSb.toString(), false, true);
            this.ilb.appendLine("public static final String ", upperUnderscoreKey, " = \"", key, "\";");
        }
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        for (TemplateNode template : publicBasicTemplateMap.values()) {
            this.visit(template);
        }
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private ", javaClassName, "() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine("\"", node.getFileName(), "\",");
        this.ilb.appendLine("\"", node.getNamespace(), "\",");
        ArrayList itemSnippets = Lists.newArrayList();
        itemSnippets.addAll(publicBasicTemplateMap.keySet());
        GenerateParseInfoVisitor.appendImmutableList(this.ilb, "<SoyTemplateInfo>", itemSnippets);
        this.ilb.appendLineEnd(",");
        SortedMap<String, SoyFileInfo.CssTagsPrefixPresence> cssNameMap = new CollectCssNamesVisitor().exec(node);
        ImmutableMap.Builder cssTagPrefixes = ImmutableMap.builder();
        for (Map.Entry entry : cssNameMap.entrySet()) {
            cssTagPrefixes.put((Object)("\"" + (String)entry.getKey() + "\""), (Object)("CssTagsPrefixPresence." + ((SoyFileInfo.CssTagsPrefixPresence)((Object)entry.getValue())).name()));
        }
        GenerateParseInfoVisitor.appendImmutableMap(this.ilb, "<String, CssTagsPrefixPresence>", (Map<String, String>)cssTagPrefixes.build());
        this.ilb.appendLineEnd(",");
        ImmutableMap.Builder pluginInstanceSnippets = ImmutableMap.builder();
        for (Map.Entry entry : pluginInstances.entrySet()) {
            pluginInstanceSnippets.put((Object)("\"" + (String)entry.getKey() + "\""), (Object)("\"" + (String)entry.getValue() + "\""));
        }
        GenerateParseInfoVisitor.appendImmutableMap(this.ilb, "<String, String>", (Map<String, String>)pluginInstanceSnippets.build());
        this.ilb.appendLineEnd(");");
        this.ilb.decreaseIndent(2);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private static final ", javaClassName, " __INSTANCE__ =");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine("new ", javaClassName, "();");
        this.ilb.decreaseIndent(2);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("public static ", javaClassName, " getInstance() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __INSTANCE__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.generatedFiles.put(javaClassName + ".java", this.ilb.toString());
        this.ilb = null;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        if (node.getVisibility() != Visibility.PUBLIC || node instanceof TemplateDelegateNode) {
            return;
        }
        HashSet<String> directParamNames = new HashSet<String>();
        for (TemplateParam param : node.getParams()) {
            directParamNames.add(param.name());
        }
        TemplateMetadata nodeMetadata = this.templateRegistry.getMetadata(node);
        IndirectParamsCalculator.IndirectParamsInfo indirectParamsInfo = new IndirectParamsCalculator(this.templateRegistry).calculateIndirectParams(nodeMetadata);
        String upperUnderscoreName = this.convertToUpperUnderscore(node.getPartialTemplateName().substring(1));
        String templateInfoClassName = CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, upperUnderscoreName) + "SoyTemplateInfo";
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine(new Object[0]);
        GenerateParseInfoVisitor.appendJavadoc(this.ilb, Optional.ofNullable(node.getSoyDocDesc()).orElse(""), true, false);
        this.ilb.appendLine("public static final class ", templateInfoClassName, " extends SoyTemplateInfo {");
        this.ilb.increaseIndent();
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("/** This template's full name. */");
        this.ilb.appendLine("public static final String __NAME__ = \"", node.getTemplateName(), "\";");
        this.ilb.appendLine("/** This template's partial name. */");
        this.ilb.appendLine("public static final String __PARTIAL_NAME__ = \"", node.getPartialTemplateName(), "\";");
        boolean hasSeenFirstDirectParam = false;
        boolean hasSwitchedToIndirectParams = false;
        for (Object param : node.getParams()) {
            if (!hasSeenFirstDirectParam) {
                this.ilb.appendLine(new Object[0]);
                hasSeenFirstDirectParam = true;
            }
            if (((TemplateParam)param).desc() != null) {
                GenerateParseInfoVisitor.appendJavadoc(this.ilb, ((TemplateParam)param).desc(), false, false);
            }
            this.ilb.appendLine("public static final String ", this.convertToUpperUnderscore(((TemplateParam)param).name()), " = \"", ((TemplateParam)param).name(), "\";");
        }
        for (Object param : indirectParamsInfo.indirectParams.values()) {
            if (directParamNames.contains(((TemplateMetadata.Parameter)param).getName())) continue;
            if (!hasSwitchedToIndirectParams) {
                this.ilb.appendLine(new Object[0]);
                this.ilb.appendLine("// Indirect params.");
                hasSwitchedToIndirectParams = true;
            }
            TreeSet sortedJavadocCalleeNames = Sets.newTreeSet();
            for (TemplateMetadata transitiveCallee : indirectParamsInfo.paramKeyToCalleesMultimap.get((Object)((TemplateMetadata.Parameter)param).getName())) {
                String javadocCalleeName = GenerateParseInfoVisitor.buildTemplateNameForJavadoc(node.getParent(), transitiveCallee);
                sortedJavadocCalleeNames.add(javadocCalleeName);
            }
            String javadoc = "Listed by " + Joiner.on((String)", ").join((Iterable)sortedJavadocCalleeNames) + ".";
            GenerateParseInfoVisitor.appendJavadoc(this.ilb, javadoc, false, true);
            this.ilb.appendLine("public static final String ", this.convertToUpperUnderscore(((TemplateMetadata.Parameter)param).getName()), " = \"", ((TemplateMetadata.Parameter)param).getName(), "\";");
        }
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private ", templateInfoClassName, "() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("super(");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine("\"", node.getTemplateName(), "\",");
        if (!nodeMetadata.getParameters().isEmpty() || !indirectParamsInfo.indirectParams.isEmpty()) {
            ImmutableMap.Builder entrySnippetPairs = ImmutableMap.builder();
            HashSet<String> seenParams = new HashSet<String>();
            for (TemplateMetadata.Parameter param : Iterables.concat(nodeMetadata.getParameters(), (Iterable)indirectParamsInfo.indirectParams.values())) {
                if (!seenParams.add(param.getName())) continue;
                entrySnippetPairs.put((Object)("\"" + param.getName() + "\""), (Object)(param.isRequired() ? "ParamRequisiteness.REQUIRED" : "ParamRequisiteness.OPTIONAL"));
            }
            GenerateParseInfoVisitor.appendImmutableMap(this.ilb, "<String, ParamRequisiteness>", (Map<String, String>)entrySnippetPairs.build());
            this.ilb.appendLineEnd(");");
        } else {
            this.ilb.appendLine("ImmutableMap.<String, ParamRequisiteness>of());");
        }
        this.ilb.decreaseIndent(2);
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("private static final ", templateInfoClassName, " __INSTANCE__ =");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine("new ", templateInfoClassName, "();");
        this.ilb.decreaseIndent(2);
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("public static ", templateInfoClassName, " getInstance() {");
        this.ilb.increaseIndent();
        this.ilb.appendLine("return __INSTANCE__;");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.decreaseIndent();
        this.ilb.appendLine("}");
        this.ilb.appendLine(new Object[0]);
        this.ilb.appendLine("/** Same as ", templateInfoClassName, ".getInstance(). */");
        this.ilb.appendLine("public static final ", templateInfoClassName, " ", upperUnderscoreName, " =");
        this.ilb.increaseIndent(2);
        this.ilb.appendLine(templateInfoClassName, ".getInstance();");
        this.ilb.decreaseIndent(2);
    }

    private String convertToUpperUnderscore(String ident) {
        String result = this.convertedIdents.computeIfAbsent(ident, BaseUtils::convertToUpperUnderscore);
        return result;
    }

    private void findProtoTypesRecurse(SoyType type, SortedSet<String> protoTypes) {
        switch (type.getKind()) {
            case PROTO: {
                protoTypes.add(((SoyProtoType)type).getDescriptorExpression());
                break;
            }
            case PROTO_ENUM: {
                protoTypes.add(((SoyProtoEnumType)type).getDescriptorExpression());
                break;
            }
            case UNION: {
                for (SoyType member : ((UnionType)type).getMembers()) {
                    this.findProtoTypesRecurse(member, protoTypes);
                }
                break;
            }
            case LIST: {
                ListType listType = (ListType)type;
                this.findProtoTypesRecurse(listType.getElementType(), protoTypes);
                break;
            }
            case MAP: 
            case LEGACY_OBJECT_MAP: {
                AbstractMapType mapType = (AbstractMapType)type;
                this.findProtoTypesRecurse(mapType.getKeyType(), protoTypes);
                this.findProtoTypesRecurse(mapType.getValueType(), protoTypes);
                break;
            }
            case RECORD: {
                RecordType recordType = (RecordType)type;
                for (SoyType fieldType : recordType.getMembers().values()) {
                    this.findProtoTypesRecurse(fieldType, protoTypes);
                }
                break;
            }
            case VE: {
                SoyType soyType;
                VeType veType = (VeType)type;
                if (!veType.getDataType().isPresent() || (soyType = this.typeRegistry.getType(veType.getDataType().get())).getKind() != SoyType.Kind.PROTO) break;
                protoTypes.add(((SoyProtoType)soyType).getDescriptorExpression());
                break;
            }
        }
    }

    @VisibleForTesting
    static void appendJavadoc(IndentedLinesBuilder ilb, String doc, boolean forceMultiline, boolean wrapAt100Chars) {
        if (wrapAt100Chars) {
            int wrapLen = 100 - ilb.getCurrIndentLen() - 7;
            ArrayList wrappedLines = Lists.newArrayList();
            for (String line : Splitter.on((char)'\n').split((CharSequence)doc)) {
                while (line.length() > wrapLen) {
                    int spaceIndex = line.lastIndexOf(32, wrapLen);
                    if (spaceIndex >= 0) {
                        wrappedLines.add(line.substring(0, spaceIndex));
                        line = line.substring(spaceIndex + 1);
                        continue;
                    }
                    wrappedLines.add(line.substring(0, wrapLen));
                    line = line.substring(wrapLen);
                }
                wrappedLines.add(line);
            }
            doc = Joiner.on((String)"\n").join((Iterable)wrappedLines);
        }
        if (doc.contains("\n") || forceMultiline) {
            ilb.appendLine("/**");
            for (String line : Splitter.on((char)'\n').split((CharSequence)doc)) {
                ilb.appendLine(" * ", line);
            }
            ilb.appendLine(" */");
        } else {
            ilb.appendLine("/** ", doc, " */");
        }
    }

    private static String buildTemplateNameForJavadoc(SoyFileNode currSoyFile, TemplateMetadata template) {
        StringBuilder resultSb = new StringBuilder();
        if (template.getSourceLocation().getFilePath().equals(currSoyFile.getFilePath()) && template.getTemplateKind() != TemplateMetadata.Kind.DELTEMPLATE) {
            resultSb.append(template.getTemplateName().substring(template.getTemplateName().lastIndexOf(46)));
        } else {
            switch (template.getTemplateKind()) {
                case BASIC: 
                case ELEMENT: {
                    resultSb.append(template.getTemplateName());
                    break;
                }
                case DELTEMPLATE: {
                    resultSb.append(template.getDelTemplateName());
                    if (template.getDelTemplateVariant().isEmpty()) break;
                    resultSb.append(':');
                    resultSb.append(template.getDelTemplateVariant());
                }
            }
        }
        if (template.getVisibility() != Visibility.PUBLIC) {
            resultSb.append(" (private)");
        }
        if (template.getTemplateKind() == TemplateMetadata.Kind.DELTEMPLATE) {
            resultSb.append(" (delegate)");
        }
        return resultSb.toString();
    }

    private static void appendImmutableList(IndentedLinesBuilder ilb, String typeParamSnippet, Collection<String> itemSnippets) {
        GenerateParseInfoVisitor.appendListOrSetHelper(ilb, "ImmutableList." + typeParamSnippet + "of", itemSnippets);
    }

    private static void appendListOrSetHelper(IndentedLinesBuilder ilb, String creationFunctionSnippet, Collection<String> itemSnippets) {
        if (itemSnippets.isEmpty()) {
            ilb.appendLineStart(creationFunctionSnippet, "()");
        } else {
            ilb.appendLine(creationFunctionSnippet, "(");
            boolean isFirst = true;
            for (String item : itemSnippets) {
                if (isFirst) {
                    isFirst = false;
                } else {
                    ilb.appendLineEnd(",");
                }
                ilb.appendLineStart("    ", item);
            }
            ilb.append(")");
        }
    }

    private static void appendImmutableMap(IndentedLinesBuilder ilb, String typeParamSnippet, Map<String, String> entrySnippetPairs) {
        if (entrySnippetPairs.isEmpty()) {
            ilb.appendLineStart("ImmutableMap.", typeParamSnippet, "of()");
        } else {
            ilb.appendLine("ImmutableMap.", typeParamSnippet, "builder()");
            for (Map.Entry<String, String> entrySnippetPair : entrySnippetPairs.entrySet()) {
                ilb.appendLine("    .put(", entrySnippetPair.getKey(), ", ", entrySnippetPair.getValue(), ")");
            }
            ilb.appendLineStart("    .build()");
        }
    }

    private static class CollectCssNamesVisitor
    extends AbstractSoyNodeVisitor<SortedMap<String, SoyFileInfo.CssTagsPrefixPresence>> {
        private SortedMap<String, SoyFileInfo.CssTagsPrefixPresence> cssNamesMap = Maps.newTreeMap();

        private CollectCssNamesVisitor() {
        }

        @Override
        public SortedMap<String, SoyFileInfo.CssTagsPrefixPresence> exec(SoyNode node) {
            for (FunctionNode fn : SoyTreeUtils.getAllFunctionInvocations(node, BuiltinFunction.CSS)) {
                String selector = ((StringNode)Iterables.getLast(fn.getChildren())).getValue();
                this.collectSelector(selector, fn.numChildren() > 1);
            }
            return this.cssNamesMap;
        }

        private void collectSelector(String selector, boolean hasComponentName) {
            SoyFileInfo.CssTagsPrefixPresence additionalCssTagsPrefixPresence;
            SoyFileInfo.CssTagsPrefixPresence existingCssTagsPrefixPresence = (SoyFileInfo.CssTagsPrefixPresence)((Object)this.cssNamesMap.get(selector));
            SoyFileInfo.CssTagsPrefixPresence cssTagsPrefixPresence = additionalCssTagsPrefixPresence = hasComponentName ? SoyFileInfo.CssTagsPrefixPresence.ALWAYS : SoyFileInfo.CssTagsPrefixPresence.NEVER;
            if (existingCssTagsPrefixPresence == null) {
                this.cssNamesMap.put(selector, additionalCssTagsPrefixPresence);
            } else if (existingCssTagsPrefixPresence != additionalCssTagsPrefixPresence) {
                this.cssNamesMap.put(selector, SoyFileInfo.CssTagsPrefixPresence.SOMETIMES);
            }
        }
    }

    @VisibleForTesting
    static enum JavaClassNameSource {
        SOY_FILE_NAME,
        SOY_NAMESPACE_LAST_PART,
        GENERIC;

        private static final Pattern ALL_UPPER_WORD;
        private static final Pattern ALL_LOWER_WORD;
        private static final Pattern NON_LETTER_DIGIT;

        @VisibleForTesting
        String generateBaseClassName(SoyFileNode soyFile) {
            switch (this) {
                case SOY_FILE_NAME: {
                    String fileName = soyFile.getFileName();
                    if (fileName == null) {
                        throw new IllegalArgumentException("Trying to generate Java class name based on Soy file name, but Soy file name was not provided.");
                    }
                    if (fileName.toLowerCase().endsWith(".soy")) {
                        fileName = fileName.substring(0, fileName.length() - 4);
                    }
                    return JavaClassNameSource.makeUpperCamelCase(fileName);
                }
                case SOY_NAMESPACE_LAST_PART: {
                    String namespace = soyFile.getNamespace();
                    String namespaceLastPart = namespace.substring(namespace.lastIndexOf(46) + 1);
                    return JavaClassNameSource.makeUpperCamelCase(namespaceLastPart);
                }
                case GENERIC: {
                    return "File";
                }
            }
            throw new AssertionError();
        }

        private static String makeUpperCamelCase(String str) {
            str = JavaClassNameSource.makeWordsCapitalized(str, ALL_UPPER_WORD);
            str = JavaClassNameSource.makeWordsCapitalized(str, ALL_LOWER_WORD);
            str = NON_LETTER_DIGIT.matcher(str).replaceAll("");
            return str;
        }

        private static String makeWordsCapitalized(String str, Pattern wordPattern) {
            StringBuffer sb = new StringBuffer();
            Matcher wordMatcher = wordPattern.matcher(str);
            while (wordMatcher.find()) {
                String oldWord = wordMatcher.group();
                StringBuilder newWord = new StringBuilder();
                int n = oldWord.length();
                for (int i = 0; i < n; ++i) {
                    if (i == 0) {
                        newWord.append(Character.toUpperCase(oldWord.charAt(i)));
                        continue;
                    }
                    newWord.append(Character.toLowerCase(oldWord.charAt(i)));
                }
                wordMatcher.appendReplacement(sb, Matcher.quoteReplacement(newWord.toString()));
            }
            wordMatcher.appendTail(sb);
            return sb.toString();
        }

        static {
            ALL_UPPER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [A-Z]+  (?= [^A-Za-z] | $)", 4);
            ALL_LOWER_WORD = Pattern.compile("(?<= [^A-Za-z] | ^)  [a-z]+  (?= [^a-z] | $)", 4);
            NON_LETTER_DIGIT = Pattern.compile("[^A-Za-z0-9]");
        }
    }
}

