/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.restricted;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.msgs.SoyMsgException;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.Objects;

@Immutable
public final class SoyMsgPluralCaseSpec {
    private static final EnumMap<Type, String> TYPE_TO_STRING = new EnumMap(Type.class);
    private final Type type;
    private final long explicitValue;

    public SoyMsgPluralCaseSpec(String typeStr) {
        this(Type.valueOf(Ascii.toUpperCase((String)typeStr)));
    }

    public SoyMsgPluralCaseSpec(Type type) {
        this.type = (Type)((Object)Preconditions.checkNotNull((Object)((Object)type)));
        this.explicitValue = -1L;
    }

    public SoyMsgPluralCaseSpec(long explicitValue) {
        if (explicitValue < 0L) {
            throw new SoyMsgException("Negative plural case value.");
        }
        this.type = Type.EXPLICIT;
        this.explicitValue = explicitValue;
    }

    public Type getType() {
        return this.type;
    }

    public long getExplicitValue() {
        return this.explicitValue;
    }

    public String toString() {
        return this.type == Type.EXPLICIT ? "=" + this.explicitValue : TYPE_TO_STRING.get((Object)this.type);
    }

    public boolean equals(Object other) {
        if (!(other instanceof SoyMsgPluralCaseSpec)) {
            return false;
        }
        SoyMsgPluralCaseSpec otherSpec = (SoyMsgPluralCaseSpec)other;
        return this.type == otherSpec.type && this.explicitValue == otherSpec.explicitValue;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{SoyMsgPluralCaseSpec.class, this.type, this.explicitValue});
    }

    static {
        for (Type t : EnumSet.allOf(Type.class)) {
            TYPE_TO_STRING.put(t, Ascii.toLowerCase((String)t.name()));
        }
    }

    public static enum Type {
        EXPLICIT,
        ZERO,
        ONE,
        TWO,
        FEW,
        MANY,
        OTHER;

    }
}

