/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.msgs.internal;

import com.google.common.collect.Lists;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsg;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.List;
import javax.annotation.Nullable;

public final class InsertMsgsVisitor {
    private static final SoyErrorKind ENCOUNTERED_PLURAL_OR_SELECT = SoyErrorKind.of("JS code generation currently only supports plural/select messages when shouldGenerateGoogMsgDefs is true.", new SoyErrorKind.StyleAllowance[0]);
    @Nullable
    private final SoyMsgBundle msgBundle;
    private final ErrorReporter errorReporter;
    private IdGenerator nodeIdGen;
    private List<SoyNode.StandaloneNode> currReplacementNodes;

    public InsertMsgsVisitor(@Nullable SoyMsgBundle msgBundle, ErrorReporter errorReporter) {
        this.msgBundle = msgBundle;
        this.errorReporter = errorReporter;
    }

    public void insertMsgs(SoyNode node) {
        this.nodeIdGen = node.getNearestAncestor(SoyFileSetNode.class).getNodeIdGenerator();
        for (MsgFallbackGroupNode msgNode : SoyTreeUtils.getAllNodesOfType(node, MsgFallbackGroupNode.class)) {
            this.replaceMsgNode(msgNode);
        }
        for (FunctionNode fnNode : SoyTreeUtils.getAllFunctionInvocations(node, BuiltinFunction.IS_PRIMARY_MSG_IN_USE)) {
            this.replaceIsPrimaryMsgInUseFunction(fnNode);
        }
    }

    private void replaceMsgNode(MsgFallbackGroupNode node) {
        for (MsgNode msg : node.getChildren()) {
            if (!msg.isPlrselMsg()) continue;
            this.errorReporter.report(node.getSourceLocation(), ENCOUNTERED_PLURAL_OR_SELECT, new Object[0]);
            return;
        }
        this.currReplacementNodes = null;
        if (this.msgBundle != null) {
            for (MsgNode msg : node.getChildren()) {
                SoyMsg translation = this.msgBundle.getMsg(MsgUtils.computeMsgIdForDualFormat(msg));
                if (translation == null) continue;
                this.buildReplacementNodesFromTranslation(msg, translation);
                break;
            }
        }
        if (this.currReplacementNodes == null) {
            this.buildReplacementNodesFromSource((MsgNode)node.getChild(0));
        }
        ParentNode parent = node.getParent();
        int indexInParent = parent.getChildIndex(node);
        parent.removeChild(indexInParent);
        parent.addChildren(indexInParent, this.currReplacementNodes);
        this.currReplacementNodes = null;
    }

    private void buildReplacementNodesFromTranslation(MsgNode msg, SoyMsg translation) {
        this.currReplacementNodes = Lists.newArrayList();
        for (SoyMsgPart msgPart : translation.getParts()) {
            if (msgPart instanceof SoyMsgRawTextPart) {
                String rawText = ((SoyMsgRawTextPart)msgPart).getRawText();
                this.currReplacementNodes.add(new RawTextNode(this.nodeIdGen.genId(), rawText, msg.getSourceLocation()));
                continue;
            }
            if (msgPart instanceof SoyMsgPlaceholderPart) {
                String placeholderName = ((SoyMsgPlaceholderPart)msgPart).getPlaceholderName();
                MsgPlaceholderNode placeholderNode = msg.getRepPlaceholderNode(placeholderName);
                for (SoyNode.StandaloneNode contentNode : placeholderNode.getChildren()) {
                    if (contentNode instanceof MsgHtmlTagNode) {
                        this.currReplacementNodes.addAll(((MsgHtmlTagNode)contentNode).getChildren());
                        continue;
                    }
                    this.currReplacementNodes.add(contentNode);
                }
                continue;
            }
            throw new AssertionError();
        }
    }

    private void buildReplacementNodesFromSource(MsgNode msg) {
        this.currReplacementNodes = Lists.newArrayList();
        for (SoyNode.StandaloneNode child : msg.getChildren()) {
            if (child instanceof RawTextNode) {
                this.currReplacementNodes.add(child);
                continue;
            }
            if (child instanceof MsgPlaceholderNode) {
                for (SoyNode.StandaloneNode contentNode : ((MsgPlaceholderNode)child).getChildren()) {
                    if (contentNode instanceof MsgHtmlTagNode) {
                        this.currReplacementNodes.addAll(((MsgHtmlTagNode)contentNode).getChildren());
                        continue;
                    }
                    this.currReplacementNodes.add(contentNode);
                }
                continue;
            }
            throw new AssertionError();
        }
    }

    private void replaceIsPrimaryMsgInUseFunction(FunctionNode node) {
        boolean isPrimaryMsgInUse;
        if (this.msgBundle == null) {
            isPrimaryMsgInUse = true;
        } else {
            long primaryMsgId = ((IntegerNode)node.getChild(1)).getValue();
            long fallbackMsgId = ((IntegerNode)node.getChild(2)).getValue();
            isPrimaryMsgInUse = !this.msgBundle.getMsgParts(primaryMsgId).isEmpty() || this.msgBundle.getMsgParts(fallbackMsgId).isEmpty();
        }
        node.getParent().replaceChild(node, new BooleanNode(isPrimaryMsgInUse, node.getSourceLocation()));
    }
}

