/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.logging;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.logging.AutoValue_ValidatedLoggingConfig_ValidatedLoggableElement;
import com.google.template.soy.logging.LoggableElement;
import com.google.template.soy.logging.LoggingConfig;
import java.util.LinkedHashMap;
import java.util.Optional;
import javax.annotation.Nullable;

public final class ValidatedLoggingConfig {
    private static final ValidatedLoggableElement UNDEFINED_VE = ValidatedLoggableElement.create(LoggableElement.newBuilder().setName("UndefinedVe").setId(-1L).build());
    public static final ValidatedLoggingConfig EMPTY = ValidatedLoggingConfig.create(LoggingConfig.getDefaultInstance());
    private static final long MAX_ID_VALUE = 0x1FFFFFFFFFFFFFL;
    private static final long MIN_ID_VALUE = -9007199254740991L;
    private final ImmutableMap<String, ValidatedLoggableElement> elementsByName;

    public static ValidatedLoggingConfig create(LoggingConfig configProto) {
        LinkedHashMap<String, ValidatedLoggableElement> elementsByName = new LinkedHashMap<String, ValidatedLoggableElement>();
        LinkedHashMap<Long, ValidatedLoggableElement> elementsById = new LinkedHashMap<Long, ValidatedLoggableElement>();
        elementsByName.put(UNDEFINED_VE.getName(), UNDEFINED_VE);
        elementsById.put(UNDEFINED_VE.getId(), UNDEFINED_VE);
        for (LoggableElement element : ImmutableSet.copyOf(configProto.getElementList())) {
            String name = element.getName();
            Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(name), (String)"'%s' is not a valid identifier", (Object)name);
            Preconditions.checkArgument((-9007199254740991L <= element.getId() && element.getId() <= 0x1FFFFFFFFFFFFFL ? 1 : 0) != 0, (String)"ID %s for '%s' must be between %s and %s (inclusive).", (Object)element.getId(), (Object)name, (Object)-9007199254740991L, (Object)0x1FFFFFFFFFFFFFL);
            ValidatedLoggableElement elementConfig = ValidatedLoggableElement.create(element);
            ValidatedLoggableElement oldWithSameId = elementsById.put(elementConfig.getId(), elementConfig);
            if (oldWithSameId != null) {
                throw new IllegalArgumentException(String.format("Found 2 LoggableElements with the same id %d: %s and %s", elementConfig.getId(), oldWithSameId.getName(), elementConfig.getName()));
            }
            ValidatedLoggableElement oldWithSameName = elementsByName.put(elementConfig.getName(), elementConfig);
            if (oldWithSameName == null) continue;
            throw new IllegalArgumentException(String.format("Found 2 LoggableElements with the same name %s, their ids are %d and %d", elementConfig.getName(), oldWithSameName.getId(), elementConfig.getId()));
        }
        return new ValidatedLoggingConfig((ImmutableMap<String, ValidatedLoggableElement>)ImmutableMap.copyOf(elementsByName));
    }

    private ValidatedLoggingConfig(ImmutableMap<String, ValidatedLoggableElement> elementsByName) {
        this.elementsByName = elementsByName;
    }

    @Nullable
    public ValidatedLoggableElement getElement(String identifier) {
        return (ValidatedLoggableElement)this.elementsByName.get((Object)identifier);
    }

    public ImmutableSet<String> allKnownIdentifiers() {
        return this.elementsByName.keySet();
    }

    @AutoValue
    public static abstract class ValidatedLoggableElement {
        static ValidatedLoggableElement create(LoggableElement element) {
            return new AutoValue_ValidatedLoggingConfig_ValidatedLoggableElement(element.getName(), element.getId(), element.getProtoType().isEmpty() ? Optional.empty() : Optional.of(element.getProtoType()));
        }

        ValidatedLoggableElement() {
        }

        public abstract String getName();

        public abstract long getId();

        public abstract Optional<String> getProtoName();
    }
}

