/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.internal.JsRuntime;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.UnionType;

final class Truthiness {
    private static final ImmutableSet<SoyType.Kind> TYPES_TO_COERCE = Sets.immutableEnumSet((Enum)SoyType.Kind.ANY, (Enum[])new SoyType.Kind[]{SoyType.Kind.UNKNOWN, SoyType.Kind.HTML, SoyType.Kind.ATTRIBUTES, SoyType.Kind.JS, SoyType.Kind.CSS, SoyType.Kind.URI, SoyType.Kind.TRUSTED_RESOURCE_URI});

    private Truthiness() {
    }

    static Expression maybeCoerce(SoyType type, Expression chunk) {
        if (TYPES_TO_COERCE.contains((Object)type.getKind())) {
            return JsRuntime.SOY_COERCE_TO_BOOLEAN.call(chunk);
        }
        if (type instanceof UnionType) {
            for (SoyType member : ((UnionType)type).getMembers()) {
                if (!TYPES_TO_COERCE.contains((Object)member.getKind())) continue;
                return JsRuntime.SOY_COERCE_TO_BOOLEAN.call(chunk);
            }
        }
        return chunk;
    }
}

