/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.annotation.Nullable;

public final class SoyToJsVariableMappings {
    private final Map<String, Expression> mappings;
    private final Map<MsgFallbackGroupNode, Expression> isPrimaryMsgInUseForFallbackGroup = new IdentityHashMap<MsgFallbackGroupNode, Expression>();

    private SoyToJsVariableMappings(ImmutableMap<String, ? extends Expression> initialMappings) {
        this.mappings = new HashMap<String, Expression>((Map<String, ? extends Expression>)initialMappings);
    }

    public static SoyToJsVariableMappings forNewTemplate() {
        return new SoyToJsVariableMappings((ImmutableMap<String, ? extends Expression>)ImmutableMap.of());
    }

    @VisibleForTesting
    static SoyToJsVariableMappings startingWith(ImmutableMap<String, ? extends Expression> initialMappings) {
        return new SoyToJsVariableMappings(initialMappings);
    }

    public SoyToJsVariableMappings put(String var, Expression translation) {
        this.mappings.put(var, translation);
        return this;
    }

    public SoyToJsVariableMappings setIsPrimaryMsgInUse(MsgFallbackGroupNode msg, Expression var) {
        this.isPrimaryMsgInUseForFallbackGroup.put(msg, var);
        return this;
    }

    public Expression get(String name) {
        return (Expression)Preconditions.checkNotNull((Object)this.mappings.get(name));
    }

    public Expression isPrimaryMsgInUse(MsgFallbackGroupNode msg) {
        return this.isPrimaryMsgInUseForFallbackGroup.get(msg);
    }

    @Nullable
    public Expression maybeGet(String name) {
        return this.mappings.get(name);
    }
}

