/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.collect.ImmutableMap;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.Descriptors;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.internalutils.NodeContentKinds;
import com.google.template.soy.internal.proto.ProtoUtils;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.types.SoyProtoType;

public final class JsRuntime {
    private static final GoogRequire GOOG_ARRAY = GoogRequire.create("goog.array");
    private static final GoogRequire GOOG_ASSERTS = GoogRequire.create("goog.asserts");
    private static final GoogRequire GOOG_STRING = GoogRequire.create("goog.string");
    private static final GoogRequire SOY = GoogRequire.create("soy");
    private static final GoogRequire SOY_MAP = GoogRequire.create("soy.map");
    private static final GoogRequire SOY_NEWMAPS = GoogRequire.create("soy.newmaps");
    private static final GoogRequire SOY_ASSERTS = GoogRequire.create("soy.asserts");
    public static final GoogRequire SOY_VELOG = GoogRequire.create("soy.velog");
    private static final GoogRequire XID_REQUIRE = GoogRequire.create("xid");
    public static final Expression GOOG_ARRAY_MAP = GOOG_ARRAY.reference().dotAccess("map");
    public static final Expression GOOG_ASSERTS_ASSERT = GOOG_ASSERTS.reference().dotAccess("assert");
    public static final Expression GOOG_DEBUG = Expression.dottedIdNoRequire("goog.DEBUG");
    public static final Expression GOOG_GET_CSS_NAME = Expression.dottedIdNoRequire("goog.getCssName");
    public static final Expression GOOG_GET_MSG = Expression.dottedIdNoRequire("goog.getMsg");
    public static final Expression GOOG_IS_ARRAY = Expression.dottedIdNoRequire("goog.isArray");
    public static final Expression GOOG_IS_BOOLEAN = Expression.dottedIdNoRequire("goog.isBoolean");
    public static final Expression GOOG_IS_FUNCTION = Expression.dottedIdNoRequire("goog.isFunction");
    public static final Expression SOY_EQUALS = SOY.dotAccess("$$equals");
    public static final Expression GOOG_IS_NUMBER = Expression.dottedIdNoRequire("goog.isNumber");
    public static final Expression GOOG_IS_OBJECT = Expression.dottedIdNoRequire("goog.isObject");
    public static final Expression GOOG_IS_STRING = Expression.dottedIdNoRequire("goog.isString");
    public static final Expression GOOG_IS_DEF = Expression.dottedIdNoRequire("goog.isDef");
    public static final Expression GOOG_REQUIRE = Expression.dottedIdNoRequire("goog.require");
    public static final Expression GOOG_SOY_DATA_SANITIZED_CONTENT = GoogRequire.create("goog.soy.data.SanitizedContent").reference();
    public static final Expression GOOG_STRING_UNESCAPE_ENTITIES = GOOG_STRING.dotAccess("unescapeEntities");
    public static final Expression GOOG_I18N_MESSAGE_FORMAT = GoogRequire.create("goog.i18n.MessageFormat").reference();
    public static final Expression SOY_ASSERTS_ASSERT_TYPE = SOY_ASSERTS.dotAccess("assertType");
    public static final Expression SOY_ASSIGN_DEFAULTS = SOY.dotAccess("$$assignDefaults");
    public static final Expression SOY_CHECK_NOT_NULL = SOY.dotAccess("$$checkNotNull");
    public static final Expression SOY_COERCE_TO_BOOLEAN = SOY.dotAccess("$$coerceToBoolean");
    public static final Expression SOY_ESCAPE_HTML = SOY.dotAccess("$$escapeHtml");
    public static final Expression SOY_GET_DELEGATE_FN = SOY.dotAccess("$$getDelegateFn");
    public static final Expression SOY_REGISTER_DELEGATE_FN = SOY.dotAccess("$$registerDelegateFn");
    public static final Expression SOY_GET_DELTEMPLATE_ID = SOY.dotAccess("$$getDelTemplateId");
    public static final Expression SOY_IS_LOCALE_RTL = SOY.dotAccess("$$IS_LOCALE_RTL");
    public static final Expression SOY_DEBUG_SOY_TEMPLATE_INFO = SOY.dotAccess("$$debugSoyTemplateInfo");
    public static final Expression SOY_MAP_POPULATE = SOY_MAP.dotAccess("$$populateMap");
    public static final Expression SOY_MAP_IS_SOY_MAP = SOY_MAP.dotAccess("$$isSoyMap");
    public static final Expression SOY_NEWMAPS_TRANSFORM_VALUES = SOY_NEWMAPS.dotAccess("$$transformValues");
    public static final Expression SOY_VISUAL_ELEMENT = SOY_VELOG.dotAccess("$$VisualElement");
    public static final Expression SOY_VISUAL_ELEMENT_DATA = SOY_VELOG.dotAccess("$$VisualElementData");
    public static final Expression WINDOW_CONSOLE_LOG = Expression.dottedIdNoRequire("window.console.log");
    public static final Expression XID = XID_REQUIRE.reference();
    public static final Expression OPT_DATA = Expression.id("opt_data");
    public static final Expression OPT_IJ_DATA = Expression.id("opt_ijData");
    public static final Expression EXPORTS = Expression.id("exports");
    public static final ImmutableMap<String, Expression> JS_TO_PROTO_PACK_FN_BASE = ImmutableMap.builder().put((Object)SafeScriptProto.getDescriptor().getFullName(), (Object)GoogRequire.create("soydata.packSanitizedJsToProtoSoyRuntimeOnly").reference()).put((Object)SafeUrlProto.getDescriptor().getFullName(), (Object)GoogRequire.create("soydata.packSanitizedUriToProtoSoyRuntimeOnly").reference()).put((Object)SafeStyleProto.getDescriptor().getFullName(), (Object)GoogRequire.create("soydata.packSanitizedCssToSafeStyleProtoSoyRuntimeOnly").reference()).put((Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)GoogRequire.create("soydata.packSanitizedCssToSafeStyleSheetProtoSoyRuntimeOnly").reference()).put((Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object)GoogRequire.create("soydata.packSanitizedTrustedResourceUriToProtoSoyRuntimeOnly").reference()).build();
    public static final ImmutableMap<String, Expression> JS_TO_PROTO_PACK_FN = ImmutableMap.builder().put((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)GoogRequire.create("soydata.packSanitizedHtmlToProtoSoyRuntimeOnly").reference()).putAll(JS_TO_PROTO_PACK_FN_BASE).build();

    private JsRuntime() {
    }

    public static Expression extensionField(Descriptors.FieldDescriptor desc) {
        String jsExtensionImport = ProtoUtils.getJsExtensionImport(desc);
        String jsExtensionName = ProtoUtils.getJsExtensionName(desc);
        return JsRuntime.symbolWithNamespace(jsExtensionImport, jsExtensionName);
    }

    public static Expression protoToSanitizedContentConverterFunction(Descriptors.Descriptor messageType) {
        return GoogRequire.create(NodeContentKinds.toJsUnpackFunction(messageType)).reference();
    }

    public static Expression sanitizedContentOrdainerFunction(SanitizedContentKind kind) {
        return JsRuntime.symbolWithNamespace(NodeContentKinds.getJsImportForOrdainersFunctions(kind), NodeContentKinds.toJsSanitizedContentOrdainer(kind));
    }

    public static Expression sanitizedContentOrdainerFunctionForInternalBlocks(SanitizedContentKind kind) {
        return JsRuntime.symbolWithNamespace(NodeContentKinds.getJsImportForOrdainersFunctions(kind), NodeContentKinds.toJsSanitizedContentOrdainerForInternalBlocks(kind));
    }

    public static Expression protoConstructor(SoyProtoType type) {
        return GoogRequire.create(type.getNameForBackend(SoyBackendKind.JS_SRC)).reference();
    }

    public static Expression sanitizedContentType(SanitizedContentKind kind) {
        return GoogRequire.create(NodeContentKinds.toJsSanitizedContentCtorName(kind)).reference();
    }

    private static Expression symbolWithNamespace(String requireSymbol, String fullyQualifiedSymbol) {
        GoogRequire require = GoogRequire.create(requireSymbol);
        if (fullyQualifiedSymbol.equals(require.symbol())) {
            return require.reference();
        }
        String ident = fullyQualifiedSymbol.substring(require.symbol().length() + 1);
        return require.dotAccess(ident);
    }
}

