/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.jssrc.internal.TemplateAliases;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateBasicNode;
import com.google.template.soy.soytree.TemplateElementNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

final class AliasUtils {
    private static final String TEMPLATE_ALIAS_PREFIX = "$templateAlias";
    static final TemplateAliases IDENTITY_ALIASES = new TemplateAliases(){

        @Override
        public String get(String fullyQualifiedName) {
            return fullyQualifiedName;
        }
    };

    private AliasUtils() {
    }

    static boolean isExternalFunction(String alias) {
        return alias.startsWith(TEMPLATE_ALIAS_PREFIX);
    }

    static TemplateAliases createTemplateAliases(SoyFileNode fileNode) {
        HashMap<String, String> aliasMap = new HashMap<String, String>();
        HashSet<String> localTemplates = new HashSet<String>();
        int counter = 0;
        ImmutableList.Builder templates = ImmutableList.builder();
        templates.addAll(SoyTreeUtils.getAllNodesOfType(fileNode, TemplateBasicNode.class)).addAll(SoyTreeUtils.getAllNodesOfType(fileNode, TemplateElementNode.class));
        for (TemplateNode templateNode : templates.build()) {
            String partialName = templateNode.getPartialTemplateName();
            String fullyQualifiedName = templateNode.getTemplateName();
            localTemplates.add(fullyQualifiedName);
            Preconditions.checkState((partialName != null ? 1 : 0) != 0, (Object)"Aliasing not supported for V1 templates");
            String alias = "$" + partialName.substring(1);
            aliasMap.put(fullyQualifiedName, alias);
        }
        for (CallBasicNode callBasicNode : SoyTreeUtils.getAllNodesOfType(fileNode, CallBasicNode.class)) {
            String fullyQualifiedName = callBasicNode.getCalleeName();
            if (localTemplates.contains(fullyQualifiedName) || aliasMap.containsKey(fullyQualifiedName)) continue;
            String alias = TEMPLATE_ALIAS_PREFIX + ++counter;
            aliasMap.put(fullyQualifiedName, alias);
        }
        return new Aliases(aliasMap);
    }

    private static final class Aliases
    implements TemplateAliases {
        final ImmutableMap<String, String> aliasMapping;

        Aliases(Map<String, String> aliasMapping) {
            this.aliasMapping = ImmutableMap.copyOf(aliasMapping);
        }

        @Override
        public String get(String fullyQualifiedName) {
            String alias = (String)this.aliasMapping.get((Object)fullyQualifiedName);
            Preconditions.checkState((alias != null ? 1 : 0) != 0);
            return alias;
        }
    }
}

