/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_VariableDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.JsDoc;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.VariableReference;
import javax.annotation.Nullable;

@Immutable
@AutoValue
public abstract class VariableDeclaration
extends Statement {
    public static Builder builder(String name) {
        return new AutoValue_VariableDeclaration.Builder().setVarName(name).setGoogRequires((ImmutableSet<GoogRequire>)ImmutableSet.of());
    }

    abstract String varName();

    @Nullable
    abstract Expression rhs();

    @Nullable
    abstract JsDoc jsDoc();

    abstract ImmutableSet<GoogRequire> googRequires();

    public Expression ref() {
        return VariableReference.of(this);
    }

    @Override
    String getCode(int startingIndent) {
        FormattingContext ctx = new FormattingContext(startingIndent);
        ctx.appendInitialStatements(this);
        return ctx.toString();
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        if (this.rhs() != null) {
            ctx.appendInitialStatements(this.rhs());
        }
        if (this.jsDoc() != null) {
            ctx.append(this.jsDoc()).endLine();
        }
        ctx.append("var ").append(this.varName());
        if (this.rhs() != null) {
            ctx.append(" = ").appendOutputExpression(this.rhs());
        }
        ctx.append(";").endLine();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (GoogRequire require : this.googRequires()) {
            collector.add(require);
        }
        if (this.rhs() != null) {
            this.rhs().collectRequires(collector);
        }
        if (this.jsDoc() != null) {
            this.jsDoc().collectRequires(collector);
        }
    }

    @AutoValue.Builder
    public static abstract class Builder {
        abstract Builder setVarName(String var1);

        public abstract Builder setJsDoc(JsDoc var1);

        public abstract Builder setRhs(Expression var1);

        public Builder setGoogRequires(Iterable<GoogRequire> requires) {
            return this.setGoogRequires((ImmutableSet<GoogRequire>)ImmutableSet.copyOf(requires));
        }

        abstract Builder setGoogRequires(ImmutableSet<GoogRequire> var1);

        public abstract VariableDeclaration build();
    }
}

