/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Leaf;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.GoogRequire;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
@AutoValue
abstract class Leaf
extends Expression {
    Leaf() {
    }

    static Expression create(String text, boolean isCheap, Iterable<GoogRequire> require) {
        return Leaf.create(new JsExpr(text, Integer.MAX_VALUE), isCheap, (Iterable<GoogRequire>)ImmutableSet.copyOf(require));
    }

    static Leaf create(String text, boolean isCheap) {
        return Leaf.create(new JsExpr(text, Integer.MAX_VALUE), isCheap, (Iterable<GoogRequire>)ImmutableSet.of());
    }

    static Leaf create(JsExpr value, boolean isCheap, Iterable<GoogRequire> requires) {
        return new AutoValue_Leaf((ImmutableList<Statement>)ImmutableList.of(), value, (ImmutableSet<GoogRequire>)ImmutableSet.copyOf(requires), isCheap);
    }

    abstract JsExpr value();

    abstract ImmutableSet<GoogRequire> requires();

    @Override
    public abstract boolean isCheap();

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append(this.value().getText());
    }

    @Override
    public JsExpr singleExprOrName() {
        return this.value();
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (GoogRequire require : this.requires()) {
            collector.add(require);
        }
    }
}

