/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.jssrc.dsl.AutoValue_Composite;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.Statement;
import com.google.template.soy.jssrc.dsl.VariableReference;
import com.google.template.soy.jssrc.restricted.JsExpr;

@Immutable
@AutoValue
abstract class Composite
extends Expression {
    Composite() {
    }

    abstract Expression value();

    static Composite create(ImmutableList<Statement> initialStatements, Expression value) {
        Preconditions.checkState((!initialStatements.isEmpty() ? 1 : 0) != 0);
        return new AutoValue_Composite((ImmutableList<Statement>)ImmutableList.builder().addAll(initialStatements).addAll(value.initialStatements()).build(), value);
    }

    @Override
    public final boolean isCheap() {
        return this.value().isCheap();
    }

    @Override
    String getCode(int startingIndent) {
        return this.value() instanceof VariableReference ? new FormattingContext(startingIndent).appendInitialStatements(this).toString() : super.getCode(startingIndent);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        for (CodeChunk stmt : this.initialStatements()) {
            ctx.appendAll(stmt);
        }
        ctx.appendInitialStatements(this.value());
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        for (Statement stmt : this.initialStatements()) {
            stmt.collectRequires(collector);
        }
        this.value().collectRequires(collector);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.appendOutputExpression(this.value());
    }

    @Override
    public JsExpr singleExprOrName() {
        return this.value().singleExprOrName();
    }
}

