/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_Call;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Statement;

@Immutable
@AutoValue
abstract class Call
extends Operation {
    Call() {
    }

    abstract Expression receiver();

    abstract ImmutableList<Expression> args();

    static Call create(Expression receiver, ImmutableList<Expression> args) {
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(receiver.initialStatements());
        for (Expression arg : args) {
            builder.addAll(arg.initialStatements());
        }
        return new AutoValue_Call((ImmutableList<Statement>)builder.build(), receiver, args);
    }

    @Override
    int precedence() {
        return Integer.MAX_VALUE;
    }

    @Override
    Operator.Associativity associativity() {
        return Operator.Associativity.LEFT;
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.receiver().collectRequires(collector);
        for (Expression arg : this.args()) {
            arg.collectRequires(collector);
        }
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.receiver(), OperandPosition.LEFT, ctx);
        ctx.append('(');
        boolean first = true;
        for (Expression arg : this.args()) {
            if (first) {
                first = false;
            } else {
                ctx.append(", ");
            }
            arg.doFormatOutputExpr(ctx);
        }
        ctx.append(')');
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        ctx.appendInitialStatements(this.receiver());
        for (Expression arg : this.args()) {
            ctx.appendInitialStatements(arg);
        }
    }
}

