/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.exprtree.Operator;
import com.google.template.soy.jssrc.dsl.AutoValue_BinaryOperation;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.Composite;
import com.google.template.soy.jssrc.dsl.Expression;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.dsl.OperandPosition;
import com.google.template.soy.jssrc.dsl.Operation;
import com.google.template.soy.jssrc.dsl.Statement;

@Immutable
@AutoValue
abstract class BinaryOperation
extends Operation {
    BinaryOperation() {
    }

    abstract String operator();

    abstract Expression arg1();

    abstract Expression arg2();

    static Expression create(Operator operator, Expression arg1, Expression arg2) {
        Preconditions.checkState((operator != Operator.AND ? 1 : 0) != 0, (Object)"use BinaryOperation::and");
        Preconditions.checkState((operator != Operator.OR ? 1 : 0) != 0, (Object)"use BinaryOperation::or");
        return BinaryOperation.create(operator.getTokenString(), operator.getPrecedence(), operator.getAssociativity(), arg1, arg2);
    }

    static BinaryOperation create(String operator, int precedence, Operator.Associativity associativity, Expression arg1, Expression arg2) {
        return new AutoValue_BinaryOperation((ImmutableList<Statement>)ImmutableList.builder().addAll(arg1.initialStatements()).addAll(arg2.initialStatements()).build(), precedence, associativity, operator, arg1, arg2);
    }

    static Expression and(Expression lhs, Expression rhs, CodeChunk.Generator codeGenerator) {
        if (lhs.initialStatements().containsAll(rhs.initialStatements())) {
            return BinaryOperation.create("&&", Operator.AND.getPrecedence(), Operator.AND.getAssociativity(), lhs, rhs);
        }
        Expression tmp = codeGenerator.declarationBuilder().setRhs(lhs).build().ref();
        return Composite.create((ImmutableList<Statement>)ImmutableList.of((Object)Statement.ifStatement(tmp, tmp.assign(rhs).asStatement()).build()), tmp);
    }

    static Expression or(Expression lhs, Expression rhs, CodeChunk.Generator codeGenerator) {
        if (lhs.initialStatements().containsAll(rhs.initialStatements())) {
            return BinaryOperation.create("||", Operator.OR.getPrecedence(), Operator.OR.getAssociativity(), lhs, rhs);
        }
        Expression tmp = codeGenerator.declarationBuilder().setRhs(lhs).build().ref();
        return Composite.create((ImmutableList<Statement>)ImmutableList.of((Object)Statement.ifStatement(BinaryOperation.not(tmp), tmp.assign(rhs).asStatement()).build()), tmp);
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.arg1().collectRequires(collector);
        this.arg2().collectRequires(collector);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        this.formatOperand(this.arg1(), OperandPosition.LEFT, ctx);
        ctx.append(' ').append(this.operator()).append(' ');
        this.formatOperand(this.arg2(), OperandPosition.RIGHT, ctx);
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
        ctx.appendInitialStatements(this.arg1()).appendInitialStatements(this.arg2());
    }
}

