/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.util.CheckClassAdapter;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public final class ClassData {
    private final TypeInfo type;
    private final byte[] data;
    private final int numberOfFields;
    private final int numDetachStates;

    public static ClassData create(TypeInfo type, byte[] b, int numFields, int numDetachStates) {
        return new ClassData(type, b, numFields, numDetachStates);
    }

    private ClassData(TypeInfo type, byte[] data, int numberOfFields, int numDetachStates) {
        this.type = (TypeInfo)Preconditions.checkNotNull((Object)type);
        this.data = (byte[])Preconditions.checkNotNull((Object)data);
        this.numberOfFields = numberOfFields;
        this.numDetachStates = numDetachStates;
    }

    public TypeInfo type() {
        return this.type;
    }

    public byte[] data() {
        return this.data;
    }

    public int numberOfFields() {
        return this.numberOfFields;
    }

    public int numberOfDetachStates() {
        return this.numDetachStates;
    }

    public void checkClass() {
        ClassNode cv = new ClassNode();
        new ClassReader(this.data).accept((ClassVisitor)new CheckClassAdapter((ClassVisitor)cv, true), 0);
        Preconditions.checkState((boolean)this.type.internalName().equals(cv.name));
        Preconditions.checkState((this.numberOfFields == cv.fields.size() ? 1 : 0) != 0);
    }

    URL asUrl() {
        try {
            return AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                @Override
                public URL run() throws MalformedURLException {
                    return new URL("mem", "", -1, ClassData.this.type.internalName() + ".class", new URLStreamHandler(){

                        @Override
                        protected URLConnection openConnection(URL u) {
                            return new URLConnection(u){

                                @Override
                                public void connect() {
                                }

                                @Override
                                public InputStream getInputStream() {
                                    return new ByteArrayInputStream(ClassData.this.data);
                                }
                            };
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to create stream handler for resource url", e);
        }
    }

    public String toString() {
        StringWriter sw = new StringWriter();
        new ClassReader(this.data).accept((ClassVisitor)new TraceClassVisitor(null, (Printer)new Textifier(), new PrintWriter(sw)), 0);
        return sw.toString();
    }
}

