/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.internal;

import com.google.common.base.Throwables;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.jbcsrc.internal.ClassData;
import com.google.template.soy.jbcsrc.internal.MemoryClassLoader;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import javax.annotation.Nullable;

public abstract class AbstractMemoryClassLoader
extends ClassLoader {
    private static final ProtectionDomain DEFAULT_PROTECTION_DOMAIN;

    protected AbstractMemoryClassLoader() {
        this(AbstractMemoryClassLoader.class.getClassLoader());
    }

    protected AbstractMemoryClassLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    @Nullable
    @ForOverride
    protected abstract ClassData getClassData(String var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        if (name.startsWith("com.google.template.soy.jbcsrc.gen.")) {
            Object object = this.getClassLoadingLock(name);
            synchronized (object) {
                Class<?> c = this.findLoadedClass(name);
                if (c == null) {
                    c = this.findClass(name);
                }
                if (resolve) {
                    this.resolveClass(c);
                }
                return c;
            }
        }
        return super.loadClass(name, resolve);
    }

    @Override
    protected final Class<?> findClass(String name) throws ClassNotFoundException {
        ClassData classDef = this.getClassData(name);
        if (classDef == null) {
            throw new ClassNotFoundException(name);
        }
        try {
            return super.defineClass(name, classDef.data(), 0, classDef.data().length, DEFAULT_PROTECTION_DOMAIN);
        }
        catch (Throwable t) {
            t.addSuppressed(new RuntimeException("Failed to load generated class:\n" + classDef));
            Throwables.propagateIfInstanceOf((Throwable)t, ClassNotFoundException.class);
            throw Throwables.propagate((Throwable)t);
        }
    }

    @Override
    protected final URL findResource(String name) {
        if (!name.endsWith(".class")) {
            return null;
        }
        String className = name.substring(0, name.length() - ".class".length()).replace('/', '.');
        ClassData classDef = this.getClassData(className);
        if (classDef == null) {
            return null;
        }
        return classDef.asUrl();
    }

    static {
        ClassLoader.registerAsParallelCapable();
        DEFAULT_PROTECTION_DOMAIN = AccessController.doPrivileged(new PrivilegedAction<ProtectionDomain>(){

            @Override
            public ProtectionDomain run() {
                return MemoryClassLoader.class.getProtectionDomain();
            }
        });
    }
}

