/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedSet;
import com.google.errorprone.annotations.concurrent.GuardedBy;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.Continuations;
import com.google.template.soy.jbcsrc.api.OutputAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jbcsrc.shared.LegacyFunctionAdapter;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.jbcsrc.shared.RenderContext;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;

public final class SoySauceImpl
implements SoySauce {
    private final CompiledTemplates templates;
    private final SoyScopedData.Enterable apiCallScope;
    private final ImmutableMap<String, Supplier<Object>> pluginInstances;
    private final ImmutableMap<String, SoyJavaPrintDirective> printDirectives;

    public SoySauceImpl(CompiledTemplates templates, SoyScopedData.Enterable apiCallScope, ImmutableMap<String, ? extends SoyFunction> functions, ImmutableMap<String, ? extends SoyPrintDirective> printDirectives, ImmutableMap<String, Supplier<Object>> pluginInstances) {
        this.templates = (CompiledTemplates)Preconditions.checkNotNull((Object)templates);
        this.apiCallScope = (SoyScopedData.Enterable)Preconditions.checkNotNull((Object)apiCallScope);
        ImmutableMap.Builder pluginInstanceBuilder = ImmutableMap.builder();
        pluginInstanceBuilder.putAll(pluginInstances);
        for (Map.Entry entry : functions.entrySet()) {
            String fnName = (String)entry.getKey();
            if (!(entry.getValue() instanceof SoyJavaFunction)) continue;
            SoyJavaFunction fn = (SoyJavaFunction)entry.getValue();
            pluginInstanceBuilder.put((Object)fnName, (Object)Suppliers.ofInstance((Object)new LegacyFunctionAdapter(fn)));
        }
        ImmutableMap.Builder soyJavaPrintDirectives = ImmutableMap.builder();
        for (Map.Entry entry : printDirectives.entrySet()) {
            SoyPrintDirective printDirective = (SoyPrintDirective)entry.getValue();
            if (!(printDirective instanceof SoyJavaPrintDirective)) continue;
            soyJavaPrintDirectives.put((Object)((String)entry.getKey()), (Object)((SoyJavaPrintDirective)printDirective));
        }
        this.printDirectives = soyJavaPrintDirectives.build();
        this.pluginInstances = pluginInstanceBuilder.build();
    }

    public ImmutableSortedSet<String> getTransitiveIjParamsForTemplate(String templateName) {
        return this.templates.getTransitiveIjParamsForTemplate(templateName);
    }

    @Override
    public ImmutableList<String> getAllRequiredCssNamespaces(String templateName, Predicate<String> enabledDelpackages, boolean collectCssFromDelvariants) {
        return this.templates.getAllRequiredCssNamespaces(templateName, enabledDelpackages, collectCssFromDelvariants);
    }

    @Override
    public RendererImpl renderTemplate(String template) {
        CompiledTemplate.Factory factory = this.templates.getTemplateFactory(template);
        return new RendererImpl(template, factory, this.templates.getTemplateContentKind(template));
    }

    private static SoySauce.WriteContinuation doRender(CompiledTemplate template, Scoper scoper, LoggingAdvisingAppendable out, RenderContext context) throws IOException {
        RenderResult result;
        try (SoyScopedData.InScope scope = scoper.enter();){
            result = template.render(out, context);
        }
        catch (Throwable t) {
            Names.rewriteStackTrace(t);
            Throwables.throwIfInstanceOf((Throwable)t, IOException.class);
            throw t;
        }
        if (result.isDone()) {
            return Continuations.done();
        }
        return new WriteContinuationImpl(result, scoper, context, out, template);
    }

    static /* synthetic */ ImmutableMap access$100(SoySauceImpl x0) {
        return x0.printDirectives;
    }

    static /* synthetic */ CompiledTemplates access$200(SoySauceImpl x0) {
        return x0.templates;
    }

    private static final class Scoper {
        final SoyScopedData.Enterable scope;
        final BidiGlobalDir dir;
        final String localeString;

        Scoper(SoyScopedData.Enterable scope, BidiGlobalDir dir, String localeString) {
            this.scope = scope;
            this.dir = dir;
            this.localeString = localeString;
        }

        SoyScopedData.InScope enter() {
            return this.scope.enter(this.dir, this.localeString);
        }
    }

    private static final class WriteContinuationImpl
    implements SoySauce.WriteContinuation {
        final RenderResult result;
        final Object lock = new Object();
        @GuardedBy(value="lock")
        final Scoper scoper;
        @GuardedBy(value="lock")
        final RenderContext context;
        @GuardedBy(value="lock")
        final LoggingAdvisingAppendable out;
        @GuardedBy(value="lock")
        final CompiledTemplate template;
        @GuardedBy(value="lock")
        boolean hasContinueBeenCalled;

        WriteContinuationImpl(RenderResult result, Scoper scoper, RenderContext context, LoggingAdvisingAppendable out, CompiledTemplate template) {
            Preconditions.checkArgument((!result.isDone() ? 1 : 0) != 0);
            this.result = (RenderResult)Preconditions.checkNotNull((Object)result);
            this.scoper = (Scoper)Preconditions.checkNotNull((Object)scoper);
            this.context = (RenderContext)Preconditions.checkNotNull((Object)context);
            this.out = (LoggingAdvisingAppendable)Preconditions.checkNotNull((Object)out);
            this.template = (CompiledTemplate)Preconditions.checkNotNull((Object)template);
        }

        @Override
        public RenderResult result() {
            return this.result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public SoySauce.WriteContinuation continueRender() throws IOException {
            Object object = this.lock;
            synchronized (object) {
                if (this.hasContinueBeenCalled) {
                    throw new IllegalStateException("continueRender() has already been called.");
                }
                this.hasContinueBeenCalled = true;
                return SoySauceImpl.doRender(this.template, this.scoper, this.out, this.context);
            }
        }
    }

    private final class RendererImpl
    implements SoySauce.Renderer {
        private final String templateName;
        private final CompiledTemplate.Factory templateFactory;
        private final SanitizedContent.ContentKind contentKind;
        private Predicate<String> activeDelegatePackages = arg -> false;
        private SoyMsgBundle msgs = SoyMsgBundle.EMPTY;
        private SoyLogger logger = SoyLogger.NO_OP;
        private final RenderContext.Builder contextBuilder = new RenderContext.Builder().withCompiledTemplates(SoySauceImpl.access$200(SoySauceImpl.this)).withSoyPrintDirectives((Map<String, ? extends SoyJavaPrintDirective>)SoySauceImpl.access$100(SoySauceImpl.this)).withPluginInstances((Map<String, Supplier<Object>>)SoySauceImpl.access$000(SoySauceImpl.this));
        private SoyRecord data = SoyValueConverter.EMPTY_DICT;
        private SoyRecord ij = SoyValueConverter.EMPTY_DICT;
        private SanitizedContent.ContentKind expectedContentKind = SanitizedContent.ContentKind.HTML;
        private Map<String, Supplier<Object>> perRenderPluginInstances = null;

        RendererImpl(String templateName, CompiledTemplate.Factory templateFactory, SanitizedContent.ContentKind contentKind) {
            this.templateName = templateName;
            this.templateFactory = (CompiledTemplate.Factory)Preconditions.checkNotNull((Object)templateFactory);
            this.contentKind = contentKind;
        }

        @Override
        public RendererImpl setIj(Map<String, ?> record) {
            this.ij = SoyValueConverter.INSTANCE.newDictFromMap((Map)Preconditions.checkNotNull(record));
            return this;
        }

        @Override
        public SoySauce.Renderer setPluginInstances(Map<String, Supplier<Object>> pluginInstances) {
            this.perRenderPluginInstances = (Map)Preconditions.checkNotNull(pluginInstances);
            return this;
        }

        @Override
        public RendererImpl setData(Map<String, ?> record) {
            this.data = SoyValueConverter.INSTANCE.newDictFromMap((Map)Preconditions.checkNotNull(record));
            return this;
        }

        @Override
        public RendererImpl setActiveDelegatePackageSelector(Predicate<String> active) {
            this.activeDelegatePackages = (Predicate)Preconditions.checkNotNull(active);
            return this;
        }

        @Override
        public RendererImpl setCssRenamingMap(SoyCssRenamingMap cssRenamingMap) {
            this.contextBuilder.withCssRenamingMap(cssRenamingMap);
            return this;
        }

        @Override
        public RendererImpl setXidRenamingMap(SoyIdRenamingMap xidRenamingMap) {
            this.contextBuilder.withXidRenamingMap(xidRenamingMap);
            return this;
        }

        @Override
        public RendererImpl setMsgBundle(SoyMsgBundle msgs) {
            this.msgs = (SoyMsgBundle)Preconditions.checkNotNull((Object)msgs);
            return this;
        }

        @Override
        public RendererImpl setDebugSoyTemplateInfo(boolean debugSoyTemplateInfo) {
            this.contextBuilder.withDebugSoyTemplateInfo(debugSoyTemplateInfo);
            return this;
        }

        @Override
        public SoySauce.Renderer setSoyLogger(SoyLogger logger) {
            this.logger = (SoyLogger)Preconditions.checkNotNull((Object)logger);
            this.contextBuilder.hasLogger(true);
            return this;
        }

        @Override
        @Deprecated
        public SoySauce.Renderer setExpectedContentKind(SanitizedContent.ContentKind expectedContentKind) {
            Preconditions.checkNotNull((Object)((Object)expectedContentKind));
            this.expectedContentKind = expectedContentKind;
            return this;
        }

        @Override
        public SoySauce.WriteContinuation renderHtml(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.HTML);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderHtml() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.HTML);
        }

        @Override
        public SoySauce.WriteContinuation renderJs(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.JS);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderJs() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.JS);
        }

        @Override
        public SoySauce.WriteContinuation renderUri(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.URI);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderUri() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.URI);
        }

        @Override
        public SoySauce.WriteContinuation renderTrustedResourceUri(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderTrustedResourceUri() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.TRUSTED_RESOURCE_URI);
        }

        @Override
        public SoySauce.WriteContinuation renderAttributes(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.ATTRIBUTES);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderAttributes() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.ATTRIBUTES);
        }

        @Override
        public SoySauce.WriteContinuation renderCss(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(SanitizedContent.ContentKind.CSS);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<SanitizedContent> renderCss() {
            return this.renderSanitizedContent(SanitizedContent.ContentKind.CSS);
        }

        @Override
        public SoySauce.WriteContinuation renderText(AdvisingAppendable out) throws IOException {
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        public SoySauce.Continuation<String> renderText() {
            StringBuilder sb = new StringBuilder();
            OutputAppendable buf = OutputAppendable.create(sb, this.logger);
            try {
                return Continuations.stringContinuation(this.startRender(buf), sb);
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }

        @Override
        @Deprecated
        public SoySauce.WriteContinuation render(AdvisingAppendable out) throws IOException {
            this.enforceContentKind(this.expectedContentKind);
            return this.startRender(OutputAppendable.create(out, this.logger));
        }

        @Override
        @Deprecated
        public SoySauce.Continuation<String> render() {
            this.enforceContentKind(this.expectedContentKind);
            return this.renderText();
        }

        @Override
        @Deprecated
        public SoySauce.Continuation<SanitizedContent> renderStrict() {
            return this.renderSanitizedContent(this.expectedContentKind);
        }

        private SoySauce.Continuation<SanitizedContent> renderSanitizedContent(SanitizedContent.ContentKind contentKind) {
            this.enforceContentKind(contentKind);
            StringBuilder sb = new StringBuilder();
            OutputAppendable buf = OutputAppendable.create(sb, this.logger);
            try {
                return Continuations.strictContinuation(this.startRender(buf), sb, contentKind);
            }
            catch (IOException e) {
                throw new AssertionError("impossible", e);
            }
        }

        private <T> SoySauce.WriteContinuation startRender(OutputAppendable out) throws IOException {
            if (this.perRenderPluginInstances != null) {
                this.contextBuilder.withPluginInstances((Map<String, Supplier<Object>>)ImmutableMap.builder().putAll((Map)SoySauceImpl.this.pluginInstances).putAll(this.perRenderPluginInstances).build());
            }
            RenderContext context = this.contextBuilder.withMessageBundle(this.msgs).withActiveDelPackageSelector(this.activeDelegatePackages).build();
            Scoper scoper = new Scoper(SoySauceImpl.this.apiCallScope, BidiGlobalDir.forStaticIsRtl(this.msgs.isRtl()), this.msgs.getLocaleString());
            CompiledTemplate template = this.templateFactory.create(this.data, this.ij);
            return SoySauceImpl.doRender(template, scoper, out, context);
        }

        private void enforceContentKind(SanitizedContent.ContentKind expectedContentKind) {
            if (expectedContentKind == SanitizedContent.ContentKind.TEXT) {
                return;
            }
            if (expectedContentKind != this.contentKind) {
                throw new IllegalStateException("Expected template '" + this.templateName + "' to be kind=\"" + Ascii.toLowerCase((String)expectedContentKind.name()) + "\" but was kind=\"" + Ascii.toLowerCase((String)this.contentKind.name()) + "\"");
            }
        }
    }
}

