/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.api.SoySauceImpl;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.shared.internal.InternalPlugins;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.internal.SoySimpleScope;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Enumeration;
import java.util.Map;

public final class SoySauceBuilder {
    private ImmutableMap<String, SoyFunction> userFunctions = ImmutableMap.of();
    private ImmutableMap<String, SoyPrintDirective> userDirectives = ImmutableMap.of();
    private ImmutableMap<String, Supplier<Object>> userPluginInstances = ImmutableMap.of();
    private SoyScopedData scopedData;
    private ClassLoader loader;

    public SoySauceBuilder withPluginInstances(Map<String, Supplier<Object>> pluginInstances) {
        this.userPluginInstances = ImmutableMap.copyOf(pluginInstances);
        return this;
    }

    public SoySauceBuilder withClassLoader(ClassLoader loader) {
        this.loader = loader;
        return this;
    }

    SoySauceBuilder withFunctions(Map<String, ? extends SoyFunction> userFunctions) {
        this.userFunctions = ImmutableMap.copyOf(userFunctions);
        return this;
    }

    SoySauceBuilder withDirectives(Map<String, ? extends SoyPrintDirective> userDirectives) {
        this.userDirectives = ImmutableMap.copyOf(userDirectives);
        return this;
    }

    SoySauceBuilder withScope(SoyScopedData scope) {
        this.scopedData = scope;
        return this;
    }

    public SoySauce build() {
        if (this.scopedData == null) {
            this.scopedData = new SoySimpleScope();
        }
        if (this.loader == null) {
            this.loader = SoySauceBuilder.class.getClassLoader();
        }
        return new SoySauceImpl(new CompiledTemplates(SoySauceBuilder.readDelTemplatesFromMetaInf(this.loader), this.loader), this.scopedData.enterable(), this.userFunctions, (ImmutableMap<String, ? extends SoyPrintDirective>)ImmutableMap.builder().putAll(InternalPlugins.internalDirectiveMap(this.scopedData)).putAll(this.userDirectives).build(), this.userPluginInstances);
    }

    private static ImmutableSet<String> readDelTemplatesFromMetaInf(ClassLoader loader) {
        try {
            ImmutableSet.Builder builder = ImmutableSet.builder();
            Enumeration<URL> resources = loader.getResources("META-INF/services/com.google.template.soy.deltemplates");
            while (resources.hasMoreElements()) {
                URL url = resources.nextElement();
                InputStream in = url.openStream();
                Throwable throwable = null;
                try {
                    BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));
                    String line = reader.readLine();
                    while (line != null) {
                        builder.add((Object)line);
                        line = reader.readLine();
                    }
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    if (in == null) continue;
                    if (throwable != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        continue;
                    }
                    in.close();
                }
            }
            return builder.build();
        }
        catch (IOException iox) {
            throw new RuntimeException("Unable to read deltemplate listing", iox);
        }
    }
}

