/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.api;

import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import com.google.template.soy.jbcsrc.api.RenderResult;
import com.google.template.soy.logging.SoyLogger;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import java.io.IOException;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.CheckReturnValue;

public interface SoySauce {
    public Renderer renderTemplate(String var1);

    public ImmutableSet<String> getTransitiveIjParamsForTemplate(String var1);

    public ImmutableList<String> getAllRequiredCssNamespaces(String var1, Predicate<String> var2, boolean var3);

    public static interface Continuation<T> {
        public RenderResult result();

        public T get();

        @CheckReturnValue
        public Continuation<T> continueRender();
    }

    public static interface WriteContinuation {
        public RenderResult result();

        @CheckReturnValue
        public WriteContinuation continueRender() throws IOException;
    }

    public static interface Renderer {
        public Renderer setData(Map<String, ?> var1);

        public Renderer setIj(Map<String, ?> var1);

        public Renderer setPluginInstances(Map<String, Supplier<Object>> var1);

        public Renderer setCssRenamingMap(SoyCssRenamingMap var1);

        public Renderer setXidRenamingMap(SoyIdRenamingMap var1);

        public Renderer setActiveDelegatePackageSelector(Predicate<String> var1);

        public Renderer setMsgBundle(SoyMsgBundle var1);

        public Renderer setDebugSoyTemplateInfo(boolean var1);

        @Deprecated
        public Renderer setExpectedContentKind(SanitizedContent.ContentKind var1);

        public Renderer setSoyLogger(SoyLogger var1);

        @CheckReturnValue
        public WriteContinuation renderHtml(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        public Continuation<SanitizedContent> renderHtml();

        @CheckReturnValue
        public WriteContinuation renderJs(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        public Continuation<SanitizedContent> renderJs();

        @CheckReturnValue
        public WriteContinuation renderUri(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        public Continuation<SanitizedContent> renderUri();

        @CheckReturnValue
        public WriteContinuation renderTrustedResourceUri(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        public Continuation<SanitizedContent> renderTrustedResourceUri();

        @CheckReturnValue
        public WriteContinuation renderAttributes(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        public Continuation<SanitizedContent> renderAttributes();

        @CheckReturnValue
        public WriteContinuation renderCss(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        public Continuation<SanitizedContent> renderCss();

        @CheckReturnValue
        public WriteContinuation renderText(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        public Continuation<String> renderText();

        @CheckReturnValue
        @Deprecated
        public Continuation<String> render();

        @CheckReturnValue
        @Deprecated
        public WriteContinuation render(AdvisingAppendable var1) throws IOException;

        @CheckReturnValue
        @Deprecated
        public Continuation<SanitizedContent> renderStrict();
    }
}

