/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.jbcsrc.CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.internal.InnerClasses;
import com.google.template.soy.jbcsrc.internal.SoyClassWriter;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Flags;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.Statement;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.CompiledTemplate;
import com.google.template.soy.soytree.TemplateNode;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.commons.Method;

final class TemplateFactoryCompiler {
    private static final TypeInfo FACTORY_TYPE = TypeInfo.create(CompiledTemplate.Factory.class);
    private static final int FACTORY_ACCESS = 17;
    private static final Method CREATE_METHOD;
    private final CompiledTemplateMetadata template;
    private final TemplateNode templateNode;
    private final InnerClasses innerClasses;

    TemplateFactoryCompiler(CompiledTemplateMetadata currentClass, TemplateNode templateNode, InnerClasses innerClasses) {
        this.template = currentClass;
        this.templateNode = templateNode;
        this.innerClasses = innerClasses;
    }

    void compile() {
        TypeInfo factoryType = this.innerClasses.registerInnerClass("Factory", 17);
        SoyClassWriter cw = SoyClassWriter.builder(factoryType).implementing(FACTORY_TYPE).setAccess(17).sourceFileName(this.templateNode.getSourceLocation().getFileName()).build();
        this.innerClasses.registerAsInnerClass(cw, factoryType);
        this.generateStaticInitializer(cw);
        BytecodeUtils.defineDefaultConstructor(cw, factoryType);
        this.generateCreateMethod(cw, factoryType);
        cw.visitEnd();
        this.innerClasses.add(cw.toClassData());
    }

    private void generateStaticInitializer(ClassVisitor cv) {
        if (Flags.DEBUG) {
            new Statement(){

                @Override
                protected void doGen(CodeBuilder adapter) {
                    adapter.pushType(TemplateFactoryCompiler.this.template.typeInfo().type());
                    adapter.visitVarInsn(58, 0);
                    adapter.returnValue();
                }
            }.writeMethod(8, BytecodeUtils.CLASS_INIT, cv);
        }
    }

    private void generateCreateMethod(ClassVisitor cv, TypeInfo factoryType) {
        final Label start = new Label();
        final Label end = new Label();
        final LocalVariable thisVar = LocalVariable.createThisVar(factoryType, start, end);
        final LocalVariable paramsVar = LocalVariable.createLocal("params", 1, BytecodeUtils.SOY_RECORD_TYPE, start, end);
        final LocalVariable ijVar = LocalVariable.createLocal("ij", 2, BytecodeUtils.SOY_RECORD_TYPE, start, end);
        final Statement returnTemplate = Statement.returnExpression(this.template.constructor().construct(paramsVar, ijVar));
        new Statement(){

            @Override
            protected void doGen(CodeBuilder ga) {
                ga.mark(start);
                returnTemplate.gen(ga);
                ga.mark(end);
                thisVar.tableEntry(ga);
                paramsVar.tableEntry(ga);
                ijVar.tableEntry(ga);
            }
        }.writeMethod(1, CREATE_METHOD, cv);
    }

    static {
        try {
            CREATE_METHOD = Method.getMethod((java.lang.reflect.Method)CompiledTemplate.Factory.class.getDeclaredMethod("create", SoyRecord.class, SoyRecord.class));
        }
        catch (NoSuchMethodException | SecurityException e) {
            throw new AssertionError((Object)e);
        }
    }
}

