/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.primitives.Primitives;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.AutoValue_JbcSrcValueFactory_ValidationResult;
import com.google.template.soy.jbcsrc.JbcSrcJavaValue;
import com.google.template.soy.jbcsrc.JbcSrcValueErrorReporter;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyRuntimeType;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.types.ListType;
import com.google.template.soy.types.NullType;
import com.google.template.soy.types.SoyProtoEnumType;
import com.google.template.soy.types.SoyProtoType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.UnionType;
import com.google.template.soy.types.UnknownType;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

final class JbcSrcValueFactory
extends JavaValueFactory {
    private static final ImmutableSet<Class<?>> UNKNOWN_TYPES = ImmutableSet.of(SoyValue.class);
    private static final ImmutableSet<Class<?>> SANITIZED_TYPES = ImmutableSet.of(SoyValue.class, SanitizedContent.class, String.class);
    private static final ImmutableSet<Class<?>> BOOL_TYPES = ImmutableSet.of(SoyValue.class, Boolean.TYPE, BooleanData.class);
    private static final ImmutableSet<Class<?>> FLOAT_TYPES = ImmutableSet.of(SoyValue.class, Double.TYPE, FloatData.class, NumberData.class);
    private static final ImmutableSet<Class<?>> NUMBER_TYPES = ImmutableSet.of(SoyValue.class, Double.TYPE, NumberData.class);
    private static final ImmutableSet<Class<?>> INT_TYPES = ImmutableSet.of(SoyValue.class, Long.TYPE, IntegerData.class, NumberData.class, Integer.TYPE, Double.TYPE, (Object[])new Class[0]);
    private static final ImmutableSet<Class<?>> LEGACY_OBJECT_MAP_TYPES = ImmutableSet.of(SoyValue.class, SoyLegacyObjectMap.class, SoyDict.class);
    private static final ImmutableSet<Class<?>> LIST_TYPES = ImmutableSet.of(SoyValue.class, SoyList.class, List.class);
    private static final ImmutableSet<Class<?>> MAP_TYPES = ImmutableSet.of(SoyValue.class, SoyMap.class, SoyDict.class, SoyRecord.class);
    private static final ImmutableSet<Class<?>> RECORD_TYPES = ImmutableSet.of(SoyValue.class, SoyRecord.class);
    private static final ImmutableSet<Class<?>> STRING_TYPES = ImmutableSet.of(SoyValue.class, String.class, StringData.class);
    private static final ImmutableSet<Class<?>> NULL_TYPES = ImmutableSet.of(SoyValue.class, NullData.class);
    private static final ImmutableSet<Class<?>> PROTO_TYPES = ImmutableSet.of(SoyValue.class, Message.class, SoyProtoValue.class);
    private static final ImmutableSet<Class<?>> PROTO_ENUM_TYPES = ImmutableSet.of(SoyValue.class, Integer.TYPE);
    private final FunctionNode fnNode;
    private final JavaPluginContext context;
    private final PluginInstanceLookup pluginInstanceLookup;
    private final JbcSrcValueErrorReporter reporter;
    private final SoyTypeRegistry registry;

    JbcSrcValueFactory(FunctionNode fnNode, final JbcSrcPluginContext jbcPluginContext, PluginInstanceLookup pluginInstanceLookup, ErrorReporter errorReporter, SoyTypeRegistry registry) {
        this.fnNode = fnNode;
        this.pluginInstanceLookup = pluginInstanceLookup;
        this.registry = registry;
        this.reporter = new JbcSrcValueErrorReporter(errorReporter, fnNode);
        this.context = new JavaPluginContext(){

            @Override
            public JavaValue getULocale() {
                return JbcSrcJavaValue.of(jbcPluginContext.getULocale(), JbcSrcValueFactory.this.reporter);
            }

            @Override
            public JavaValue getBidiDir() {
                return JbcSrcJavaValue.of(jbcPluginContext.getBidiGlobalDir(), JbcSrcValueFactory.this.reporter);
            }

            @Override
            public JavaValue getAllRequiredCssNamespaces(JavaValue template) {
                JbcSrcJavaValue exprTemplate = (JbcSrcJavaValue)template;
                SoyExpression soyExpression = (SoyExpression)exprTemplate.expr();
                return JbcSrcJavaValue.of(jbcPluginContext.getAllRequiredCssNamespaces(soyExpression.unboxAsString()), JbcSrcValueFactory.this.reporter);
            }
        };
    }

    SoyExpression computeForJavaSource(List<SoyExpression> args) {
        JavaValue result;
        ErrorReporter.Checkpoint checkpoint = this.reporter.checkpoint();
        Preconditions.checkState((this.fnNode.getAllowedParamTypes() != null ? 1 : 0) != 0, (Object)"allowed param types must be set");
        Preconditions.checkState((this.fnNode.getAllowedParamTypes().size() == args.size() ? 1 : 0) != 0, (String)"wrong # of allowed param types (%s), expected %s", this.fnNode.getAllowedParamTypes(), (int)args.size());
        ImmutableList.Builder jvBuilder = ImmutableList.builder();
        for (int i = 0; i < args.size(); ++i) {
            jvBuilder.add((Object)JbcSrcJavaValue.of(args.get(i), (SoyType)this.fnNode.getAllowedParamTypes().get(i), this.reporter));
        }
        SoyJavaSourceFunction javaSrcFn = (SoyJavaSourceFunction)this.fnNode.getSoyFunction();
        try {
            result = javaSrcFn.applyForJavaSource(this, (List<JavaValue>)jvBuilder.build(), this.context);
            if (result == null) {
                this.reporter.nullReturn();
                result = this.errorValue();
            }
        }
        catch (Throwable t) {
            BaseUtils.trimStackTraceTo(t, this.getClass());
            this.reporter.unexpectedError(t);
            result = this.errorValue();
        }
        Optional<SoyExpression> soyExpr = this.toSoyExpression((JbcSrcJavaValue)result);
        if (this.reporter.errorsSince(checkpoint)) {
            return SoyExpression.NULL_BOXED;
        }
        return soyExpr.get();
    }

    @Override
    public JbcSrcJavaValue callStaticMethod(java.lang.reflect.Method method, JavaValue ... params) {
        if (method == null) {
            this.reporter.nullMethod("callStaticMethod");
            return this.errorValue();
        }
        Optional<Expression[]> adapted = this.adaptParams(method, params, "callStaticMethod");
        if (!adapted.isPresent()) {
            return this.errorValue();
        }
        return JbcSrcJavaValue.of(this.tryToWrapInSoyExpression(MethodRef.create(method).invoke(adapted.get())), method, this.reporter);
    }

    @Override
    public JbcSrcJavaValue callInstanceMethod(java.lang.reflect.Method method, JavaValue ... params) {
        if (method == null) {
            this.reporter.nullMethod("callInstanceMethod");
            return this.errorValue();
        }
        Expression runtime = this.pluginInstanceLookup.getPluginInstance(this.fnNode.getFunctionName()).checkedCast(method.getDeclaringClass());
        Optional<Expression[]> adapted = this.adaptParams(method, params, "callInstanceMethod");
        if (!adapted.isPresent()) {
            return this.errorValue();
        }
        return JbcSrcJavaValue.of(this.tryToWrapInSoyExpression(runtime.invoke(MethodRef.create(method), adapted.get())), method, this.reporter);
    }

    @Override
    public JbcSrcJavaValue listOf(List<JavaValue> args) {
        List soyExprs = Lists.transform(args, value -> (SoyExpression)((JbcSrcJavaValue)value).expr());
        return JbcSrcJavaValue.of(SoyExpression.asBoxedList(soyExprs), this.reporter);
    }

    @Override
    public JbcSrcJavaValue constant(double value) {
        return JbcSrcJavaValue.of(SoyExpression.forFloat(BytecodeUtils.constant(value)), this.reporter);
    }

    @Override
    public JbcSrcJavaValue constant(long value) {
        return JbcSrcJavaValue.of(SoyExpression.forInt(BytecodeUtils.constant(value)), this.reporter);
    }

    @Override
    public JbcSrcJavaValue constant(String value) {
        return JbcSrcJavaValue.of(SoyExpression.forString(BytecodeUtils.constant(value)), this.reporter);
    }

    @Override
    public JbcSrcJavaValue constant(boolean value) {
        return JbcSrcJavaValue.of(value ? SoyExpression.TRUE : SoyExpression.FALSE, this.reporter);
    }

    @Override
    public JbcSrcJavaValue constantNull() {
        return JbcSrcJavaValue.ofConstantNull(this.reporter);
    }

    private Optional<Expression[]> adaptParams(java.lang.reflect.Method method, JavaValue[] userParams, String callerMethodName) {
        if (userParams == null) {
            this.reporter.nullParamArray(method, callerMethodName);
            return Optional.empty();
        }
        Class<?>[] methodParams = method.getParameterTypes();
        if (methodParams.length != userParams.length) {
            this.reporter.invalidParameterLength(method, userParams);
            return Optional.empty();
        }
        Expression[] params = new Expression[userParams.length];
        for (int i = 0; i < userParams.length; ++i) {
            Class<?> methodParam = methodParams[i];
            if (userParams[i] == null) {
                this.reporter.nullParam(method, i + 1, methodParam);
                params[i] = JbcSrcValueFactory.stubExpression(methodParam);
                continue;
            }
            JbcSrcJavaValue jbcJv = (JbcSrcJavaValue)userParams[i];
            Expression expr = jbcJv.expr();
            if (expr instanceof SoyExpression) {
                params[i] = this.adaptParameter(method, i, methodParam, jbcJv);
                continue;
            }
            if (!BytecodeUtils.isDefinitelyAssignableFrom(Type.getType(methodParam), expr.resultType())) {
                this.reporter.invalidParameterType(method, i, methodParam, expr);
                expr = JbcSrcValueFactory.stubExpression(methodParam);
            }
            params[i] = expr;
        }
        return Optional.of(params);
    }

    private Expression adaptParameter(java.lang.reflect.Method method, int paramIdx, Class<?> expectedParamType, JbcSrcJavaValue value) {
        ValidationResult validationResult = value.isConstantNull() ? (Primitives.allPrimitiveTypes().contains(expectedParamType) ? ValidationResult.forNullToPrimitive(NullType.getInstance()) : ValidationResult.valid()) : this.isValidClassForType(expectedParamType, value.getAllowedType());
        if (validationResult.result() != ValidationResult.Result.VALID) {
            this.reporter.invalidParameterType(method, paramIdx, expectedParamType, validationResult);
            return JbcSrcValueFactory.stubExpression(expectedParamType);
        }
        SoyExpression actualParam = (SoyExpression)value.expr();
        if (value.isConstantNull()) {
            return actualParam.checkedCast(expectedParamType);
        }
        if (expectedParamType == SoyValue.class) {
            return actualParam.box();
        }
        if (SoyValue.class.isAssignableFrom(expectedParamType)) {
            return actualParam.box().checkedCast(expectedParamType);
        }
        if (expectedParamType == Integer.TYPE) {
            return actualParam.box().invoke(MethodRef.SOY_VALUE_INTEGER_VALUE, new Expression[0]);
        }
        if (expectedParamType == Double.TYPE) {
            return actualParam.coerceToDouble();
        }
        if (Message.class.isAssignableFrom(expectedParamType)) {
            if (expectedParamType.equals(Message.class)) {
                return actualParam.unboxAsMessage();
            }
            return actualParam.unboxAsMessage().checkedCast(expectedParamType);
        }
        if (expectedParamType.isEnum() && ProtocolMessageEnum.class.isAssignableFrom(expectedParamType)) {
            return MethodRef.create(expectedParamType, "forNumber", Integer.TYPE).invoke(BytecodeUtils.numericConversion(actualParam.unboxAsLong(), Type.INT_TYPE));
        }
        if (expectedParamType.equals(Boolean.TYPE)) {
            return actualParam.unboxAsBoolean();
        }
        if (expectedParamType.equals(Long.TYPE)) {
            return actualParam.unboxAsLong();
        }
        if (expectedParamType.equals(String.class)) {
            return actualParam.unboxAsString();
        }
        if (expectedParamType.equals(List.class)) {
            return actualParam.unboxAsList();
        }
        throw new AssertionError((Object)("Unable to convert parameter to " + expectedParamType));
    }

    private ValidationResult isValidClassForType(Class<?> clazz, SoyType type) {
        if (SoyTypes.isNullable(type) && Primitives.allPrimitiveTypes().contains(clazz)) {
            return ValidationResult.forNullToPrimitive(type);
        }
        if (SoyTypes.isKindOrUnionOfKind(type, SoyType.Kind.VE) || SoyTypes.isKindOrUnionOfKind(type, SoyType.Kind.VE_DATA)) {
            return ValidationResult.ve(type);
        }
        ImmutableSet<Class<?>> expectedClasses = null;
        Descriptors.Descriptor expectedDescriptor = null;
        type = SoyTypes.tryRemoveNull(type);
        switch (type.getKind()) {
            case ANY: 
            case UNKNOWN: {
                expectedClasses = UNKNOWN_TYPES;
                break;
            }
            case ATTRIBUTES: 
            case CSS: 
            case HTML: 
            case URI: 
            case TRUSTED_RESOURCE_URI: 
            case JS: {
                expectedClasses = SANITIZED_TYPES;
                break;
            }
            case BOOL: {
                expectedClasses = BOOL_TYPES;
                break;
            }
            case FLOAT: {
                expectedClasses = FLOAT_TYPES;
                break;
            }
            case INT: {
                expectedClasses = INT_TYPES;
                break;
            }
            case LEGACY_OBJECT_MAP: {
                expectedClasses = LEGACY_OBJECT_MAP_TYPES;
                break;
            }
            case LIST: {
                expectedClasses = LIST_TYPES;
                break;
            }
            case MAP: {
                expectedClasses = MAP_TYPES;
                break;
            }
            case RECORD: {
                expectedClasses = RECORD_TYPES;
                break;
            }
            case STRING: {
                expectedClasses = STRING_TYPES;
                break;
            }
            case NULL: {
                expectedClasses = NULL_TYPES;
                break;
            }
            case PROTO: {
                expectedClasses = PROTO_TYPES;
                expectedDescriptor = ((SoyProtoType)type).getDescriptor();
                break;
            }
            case PROTO_ENUM: {
                expectedClasses = PROTO_ENUM_TYPES;
                expectedDescriptor = ((SoyProtoEnumType)type).getDescriptor();
                break;
            }
            case UNION: {
                if (type.equals(SoyTypes.NUMBER_TYPE)) {
                    expectedClasses = NUMBER_TYPES;
                    break;
                }
                ValidationResult result = ValidationResult.valid();
                for (SoyType member : ((UnionType)type).getMembers()) {
                    result.merge(this.isValidClassForType(clazz, member));
                }
                return result;
            }
            case VE: 
            case VE_DATA: {
                throw new IllegalStateException("This should have been caught above");
            }
            case ERROR: {
                throw new IllegalStateException("Cannot have error type from function signature");
            }
        }
        Preconditions.checkState((expectedClasses != null ? 1 : 0) != 0, (Object)"expectedClass not set!");
        if (expectedClasses.contains(clazz)) {
            return ValidationResult.valid();
        }
        ImmutableSet expectedDescriptorNames = ImmutableSet.of();
        if (expectedDescriptor instanceof Descriptors.Descriptor) {
            expectedDescriptorNames = ImmutableSet.of((Object)JavaQualifiedNames.getClassName(expectedDescriptor));
            if (this.matchesProtoDescriptor(Message.class, clazz, (Descriptors.GenericDescriptor)expectedDescriptor)) {
                return ValidationResult.valid();
            }
        }
        if (expectedDescriptor instanceof Descriptors.EnumDescriptor) {
            expectedDescriptorNames = ImmutableSet.of((Object)JavaQualifiedNames.getClassName((Descriptors.EnumDescriptor)expectedDescriptor));
            if (clazz.isEnum() && this.matchesProtoDescriptor(ProtocolMessageEnum.class, clazz, (Descriptors.GenericDescriptor)expectedDescriptor)) {
                return ValidationResult.valid();
            }
        }
        return ValidationResult.invalid((Set)Stream.concat(expectedClasses.stream().map(Class::getName), expectedDescriptorNames.stream()).collect(ImmutableSet.toImmutableSet()));
    }

    private boolean matchesProtoDescriptor(Class<?> expectedSupertype, Class<?> actualParamClass, Descriptors.GenericDescriptor expectedDescriptor) {
        if (!expectedSupertype.isAssignableFrom(actualParamClass)) {
            return false;
        }
        return JbcSrcValueFactory.nameFromDescriptor(actualParamClass).orElse("").equals(expectedDescriptor.getFullName());
    }

    private static Optional<String> nameFromDescriptor(Class<?> protoType) {
        Descriptors.GenericDescriptor actualDescriptor;
        try {
            actualDescriptor = (Descriptors.GenericDescriptor)protoType.getDeclaredMethod("getDescriptor", new Class[0]).invoke(null, new Object[0]);
        }
        catch (ReflectiveOperationException roe) {
            return Optional.empty();
        }
        return Optional.of(actualDescriptor.getFullName());
    }

    private JbcSrcJavaValue errorValue() {
        return JbcSrcJavaValue.error(JbcSrcValueFactory.stubExpression(Boolean.TYPE), this.reporter);
    }

    static Expression stubExpression(Class<?> clazz) {
        return MethodRef.createStaticMethod(TypeInfo.create("if.you.see.this.please.report.a.bug.because.an.error.message.was.swallowed"), new Method("oops", Type.getType(clazz), new Type[0])).invoke(new Expression[0]);
    }

    private Expression tryToWrapInSoyExpression(Expression expr) {
        switch (expr.resultType().getSort()) {
            case 1: {
                return SoyExpression.forBool(expr);
            }
            case 5: {
                return SoyExpression.forInt(BytecodeUtils.numericConversion(expr, Type.LONG_TYPE));
            }
            case 7: {
                return SoyExpression.forInt(expr);
            }
            case 8: {
                return SoyExpression.forFloat(expr);
            }
            case 10: {
                if (!expr.resultType().equals((Object)BytecodeUtils.STRING_TYPE)) break;
                return SoyExpression.forString(expr);
            }
        }
        return expr;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Optional<SoyExpression> toSoyExpression(JbcSrcJavaValue pluginReturnValue) {
        boolean isPossibleProtoEnum;
        if (pluginReturnValue.isError()) {
            return Optional.empty();
        }
        SoyType expectedType = this.fnNode.getType();
        Expression expr = pluginReturnValue.expr();
        SoyExpression soyExpr = null;
        if (expr instanceof SoyExpression) {
            soyExpr = (SoyExpression)expr;
        } else {
            java.lang.reflect.Method method = pluginReturnValue.methodInfo();
            Class<?> type = method != null ? method.getReturnType() : BytecodeUtils.classFromAsmType(expr.resultType());
            if (List.class.isAssignableFrom(type)) {
                if (expectedType instanceof ListType) {
                    soyExpr = SoyExpression.forList((ListType)expectedType, expr);
                } else {
                    if (expectedType.getKind() != SoyType.Kind.UNKNOWN && expectedType.getKind() != SoyType.Kind.ANY) {
                        this.reporter.invalidReturnType(type, method);
                        return Optional.empty();
                    }
                    soyExpr = SoyExpression.forList(ListType.of(UnknownType.getInstance()), expr);
                }
            } else if (SoyValue.class.isAssignableFrom(type)) {
                soyExpr = SoyExpression.forSoyValue(expectedType, expr.checkedCast(SoyRuntimeType.getBoxedType(expectedType).runtimeType()));
            } else if (Message.class.isAssignableFrom(type)) {
                Optional<SoyType> returnType = this.soyTypeForProtoOrEnum(type, method);
                if (!returnType.isPresent()) {
                    return Optional.empty();
                }
                soyExpr = SoyExpression.forProto(SoyRuntimeType.getUnboxedType(returnType.get()).get(), expr);
            } else if (type.isEnum() && ProtocolMessageEnum.class.isAssignableFrom(type)) {
                Optional<SoyType> returnType = this.soyTypeForProtoOrEnum(type, method);
                if (!returnType.isPresent()) {
                    return Optional.empty();
                }
                if (!expectedType.isAssignableFrom(returnType.get())) {
                    this.reporter.incompatibleReturnType(returnType.get(), method);
                    return Optional.empty();
                }
                soyExpr = SoyExpression.forInt(BytecodeUtils.numericConversion(MethodRef.PROTOCOL_ENUM_GET_NUMBER.invoke(expr), Type.LONG_TYPE));
            } else {
                this.reporter.invalidReturnType(type, method);
                return Optional.empty();
            }
        }
        boolean bl = isPossibleProtoEnum = soyExpr.soyType().getKind() == SoyType.Kind.INT && this.isOrContains(expectedType, SoyType.Kind.PROTO_ENUM);
        if (!isPossibleProtoEnum && !expectedType.isAssignableFrom(soyExpr.soyType())) {
            this.reporter.incompatibleReturnType(soyExpr.soyType(), pluginReturnValue.methodInfo());
            return Optional.empty();
        }
        return Optional.of(soyExpr);
    }

    private Optional<SoyType> soyTypeForProtoOrEnum(Class<?> type, java.lang.reflect.Method method) {
        if (type == Message.class) {
            this.reporter.invalidReturnType(Message.class, method);
            return Optional.empty();
        }
        Optional<String> fullName = JbcSrcValueFactory.nameFromDescriptor(type);
        if (!fullName.isPresent()) {
            this.reporter.incompatibleReturnType(type, method);
            return Optional.empty();
        }
        SoyType returnType = this.registry.getType(fullName.get());
        if (returnType == null) {
            this.reporter.incompatibleReturnType(type, method);
            return Optional.empty();
        }
        return Optional.of(returnType);
    }

    private boolean isOrContains(SoyType type, SoyType.Kind kind) {
        if (type.getKind() == kind) {
            return true;
        }
        if (type.getKind() == SoyType.Kind.UNION) {
            for (SoyType member : ((UnionType)type).getMembers()) {
                if (member.getKind() != kind) continue;
                return true;
            }
        }
        return false;
    }

    @AutoValue
    static abstract class ValidationResult {
        ValidationResult() {
        }

        abstract Result result();

        @Nullable
        abstract SoyType allowedSoyType();

        abstract ImmutableSet<String> allowedTypes();

        ValidationResult merge(ValidationResult other) {
            if (other.result() == Result.VALID) {
                return this;
            }
            switch (this.result()) {
                case VALID: {
                    return other;
                }
                case NULL_TO_PRIMITIVE: 
                case VE: {
                    throw new IllegalStateException("unexpected merge " + this + " w/ " + other);
                }
                case INVALID: {
                    return ValidationResult.invalid((Set<String>)Sets.intersection(this.allowedTypes(), other.allowedTypes()));
                }
            }
            throw new AssertionError((Object)"above switch is exhaustive");
        }

        static ValidationResult valid() {
            return new AutoValue_JbcSrcValueFactory_ValidationResult(Result.VALID, null, (ImmutableSet<String>)ImmutableSet.of());
        }

        static ValidationResult forNullToPrimitive(SoyType type) {
            return new AutoValue_JbcSrcValueFactory_ValidationResult(Result.NULL_TO_PRIMITIVE, type, (ImmutableSet<String>)ImmutableSet.of());
        }

        static ValidationResult invalid(Set<String> allowedTypes) {
            return new AutoValue_JbcSrcValueFactory_ValidationResult(Result.INVALID, null, (ImmutableSet<String>)ImmutableSet.copyOf(allowedTypes));
        }

        static ValidationResult ve(SoyType type) {
            return new AutoValue_JbcSrcValueFactory_ValidationResult(Result.VE, type, (ImmutableSet<String>)ImmutableSet.of());
        }

        static enum Result {
            VALID,
            NULL_TO_PRIMITIVE,
            INVALID,
            VE;

        }
    }

    static interface PluginInstanceLookup {
        public Expression getPluginInstance(String var1);
    }
}

