/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.jbcsrc.JbcSrcValueErrorReporter;
import com.google.template.soy.jbcsrc.JbcSrcValueFactory;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.types.BoolType;
import com.google.template.soy.types.FloatType;
import com.google.template.soy.types.IntType;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.StringType;
import java.lang.reflect.Method;
import javax.annotation.Nullable;

final class JbcSrcJavaValue
implements JavaValue {
    private final Expression expr;
    private final JbcSrcValueErrorReporter reporter;
    @Nullable
    private final SoyType allowedType;
    @Nullable
    private final Method method;
    private final boolean error;
    private final boolean constantNull;

    static JbcSrcJavaValue error(Expression expr, JbcSrcValueErrorReporter reporter) {
        return new JbcSrcJavaValue(expr, null, null, false, true, reporter);
    }

    static JbcSrcJavaValue of(Expression expr, JbcSrcValueErrorReporter reporter) {
        if (expr instanceof SoyExpression) {
            return new JbcSrcJavaValue(expr, null, ((SoyExpression)expr).soyType(), false, false, reporter);
        }
        return new JbcSrcJavaValue(expr, null, null, false, false, reporter);
    }

    static JbcSrcJavaValue of(Expression expr, Method method, JbcSrcValueErrorReporter reporter) {
        Preconditions.checkNotNull((Object)method);
        if (expr instanceof SoyExpression) {
            return new JbcSrcJavaValue(expr, method, ((SoyExpression)expr).soyType(), false, false, reporter);
        }
        return new JbcSrcJavaValue(expr, method, null, false, false, reporter);
    }

    static JbcSrcJavaValue of(SoyExpression expr, SoyType allowedType, JbcSrcValueErrorReporter reporter) {
        return new JbcSrcJavaValue(expr, null, (SoyType)Preconditions.checkNotNull((Object)allowedType), false, false, reporter);
    }

    static JbcSrcJavaValue ofConstantNull(JbcSrcValueErrorReporter reporter) {
        return new JbcSrcJavaValue(SoyExpression.NULL, null, null, true, false, reporter);
    }

    private JbcSrcJavaValue(Expression expr, Method method, SoyType allowedType, boolean constantNull, boolean error, JbcSrcValueErrorReporter reporter) {
        this.expr = (Expression)Preconditions.checkNotNull((Object)expr);
        this.reporter = (JbcSrcValueErrorReporter)Preconditions.checkNotNull((Object)reporter);
        this.method = method;
        this.allowedType = allowedType;
        this.constantNull = constantNull;
        this.error = error;
        if (expr instanceof SoyExpression) {
            Preconditions.checkState((constantNull == (allowedType == null) ? 1 : 0) != 0, (String)"Invalid combo of constantNull (%s) and allowedType (%s). If allowedType is null, constantNull must be true. If allowedType is non-null, constantNull must be false.", (Object)constantNull, (Object)allowedType);
        } else {
            Preconditions.checkState((!constantNull ? 1 : 0) != 0, (Object)"Non-SoyExpression cannot have constantNull==true");
            Preconditions.checkState((allowedType == null ? 1 : 0) != 0, (String)"Non-SoyExpression cannot have an allowedType (%s)", (Object)allowedType);
        }
    }

    boolean isError() {
        return this.error;
    }

    Expression expr() {
        return this.expr;
    }

    @Nullable
    SoyType getAllowedType() {
        return this.allowedType;
    }

    public boolean isConstantNull() {
        return this.constantNull;
    }

    @Nullable
    Method methodInfo() {
        return this.method;
    }

    @Override
    public JbcSrcJavaValue isNonNull() {
        return JbcSrcJavaValue.of(BytecodeUtils.isNonNull(this.expr), this.reporter);
    }

    @Override
    public JbcSrcJavaValue isNull() {
        return JbcSrcJavaValue.of(BytecodeUtils.isNull(this.expr), this.reporter);
    }

    @Override
    public JbcSrcJavaValue asSoyBoolean() {
        return this.asSoyType(BoolType.getInstance(), Boolean.TYPE, "asSoyBoolean");
    }

    @Override
    public JbcSrcJavaValue asSoyFloat() {
        return this.asSoyType(FloatType.getInstance(), Double.TYPE, "asSoyFloat");
    }

    @Override
    public JbcSrcJavaValue asSoyInt() {
        return this.asSoyType(IntType.getInstance(), Long.TYPE, "asSoyInt");
    }

    @Override
    public JbcSrcJavaValue asSoyString() {
        return this.asSoyType(StringType.getInstance(), String.class, "asSoyString");
    }

    private JbcSrcJavaValue asSoyType(SoyType newType, Class<?> newClass, String methodName) {
        if (this.allowedType == null) {
            this.reporter.nonSoyExpressionNotConvertible(this.expr, newType, methodName);
            return JbcSrcJavaValue.error(JbcSrcValueFactory.stubExpression(newClass), this.reporter);
        }
        if (!this.allowedType.isAssignableFrom(newType)) {
            this.reporter.incompatibleSoyType(this.allowedType, newType, methodName);
            return JbcSrcJavaValue.error(JbcSrcValueFactory.stubExpression(newClass), this.reporter);
        }
        return new JbcSrcJavaValue(this.expr, this.method, (SoyType)Preconditions.checkNotNull((Object)newType), false, false, this.reporter);
    }

    @Override
    public JbcSrcJavaValue coerceToSoyBoolean() {
        if (!(this.expr instanceof SoyExpression) || this.constantNull) {
            this.reporter.nonSoyExpressionNotCoercible(this.expr, BoolType.getInstance(), "coerceToSoyBoolean");
            return JbcSrcJavaValue.error(JbcSrcValueFactory.stubExpression(Boolean.TYPE), this.reporter);
        }
        return new JbcSrcJavaValue(((SoyExpression)this.expr).coerceToBoolean(), this.method, BoolType.getInstance(), false, false, this.reporter);
    }

    @Override
    public JbcSrcJavaValue coerceToSoyString() {
        if (!(this.expr instanceof SoyExpression) || this.constantNull) {
            this.reporter.nonSoyExpressionNotCoercible(this.expr, StringType.getInstance(), "coerceToSoyString");
            return JbcSrcJavaValue.error(JbcSrcValueFactory.stubExpression(String.class), this.reporter);
        }
        return new JbcSrcJavaValue(((SoyExpression)this.expr).coerceToString(), this.method, StringType.getInstance(), false, false, this.reporter);
    }

    public String toString() {
        String typeStr = this.allowedType == null ? "" : ", allowedType= " + this.allowedType;
        String methodStr = this.method == null ? "" : ", method= " + this.method;
        return "JbcSrcJavaValue[expr=" + this.expr + typeStr + methodStr + "]";
    }
}

