/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.LocalVariable;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class AppendableExpression
extends Expression {
    private static final MethodRef APPEND = MethodRef.create(LoggingAdvisingAppendable.class, "append", CharSequence.class).asNonNullable();
    private static final MethodRef APPEND_CHAR = MethodRef.create(LoggingAdvisingAppendable.class, "append", Character.TYPE).asNonNullable();
    private static final MethodRef SOFT_LIMITED = MethodRef.create(LoggingAdvisingAppendable.class, "softLimitReached", new Class[0]).asCheap();
    static final MethodRef ENTER_LOGGABLE_STATEMENT = MethodRef.create(LoggingAdvisingAppendable.class, "enterLoggableElement", LogStatement.class).asNonNullable();
    private static final MethodRef EXIT_LOGGABLE_STATEMENT = MethodRef.create(LoggingAdvisingAppendable.class, "exitLoggableElement", new Class[0]).asNonNullable();
    private static final MethodRef APPEND_LOGGING_FUNCTION_INVOCATION = MethodRef.create(LoggingAdvisingAppendable.class, "appendLoggingFunctionInvocation", LoggingFunctionInvocation.class, ImmutableList.class).asNonNullable();
    private static final MethodRef LOGGING_FUNCTION_INVOCATION_CREATE = MethodRef.create(LoggingFunctionInvocation.class, "create", String.class, String.class, List.class).asNonNullable();
    private static final MethodRef SET_SANITIZED_CONTENT_KIND = MethodRef.create(LoggingAdvisingAppendable.class, "setSanitizedContentKind", SanitizedContent.ContentKind.class).asNonNullable().asCheap();
    private static final MethodRef SET_SANITIZED_CONTENT_DIRECTIONALITY = MethodRef.create(LoggingAdvisingAppendable.class, "setSanitizedContentDirectionality", Dir.class).asNonNullable().asCheap();
    private final Expression delegate;
    private final boolean hasSideEffects;
    private final boolean supportsSoftLimiting;

    static AppendableExpression forLocal(LocalVariable delegate) {
        return new AppendableExpression(delegate, false, true);
    }

    static AppendableExpression forStringBuilder(Expression delegate) {
        Preconditions.checkArgument((boolean)delegate.resultType().equals((Object)BytecodeUtils.LOGGING_ADVISING_BUILDER_TYPE));
        return new AppendableExpression(BytecodeUtils.LOGGING_ADVISING_BUILDER_TYPE, delegate, false, false);
    }

    static AppendableExpression logger() {
        return new AppendableExpression(MethodRef.RUNTIME_LOGGER.invoke(new Expression[0]), false, false);
    }

    private AppendableExpression(Expression delegate, boolean hasSideEffects, boolean supportsSoftLimiting) {
        this(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, delegate, hasSideEffects, supportsSoftLimiting);
    }

    private AppendableExpression(Type resultType, Expression delegate, boolean hasSideEffects, boolean supportsSoftLimiting) {
        super(resultType, delegate.features());
        delegate.checkAssignableTo(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE);
        Preconditions.checkArgument((boolean)delegate.isNonNullable(), (Object)"advising appendable expressions should always be non null");
        this.delegate = delegate;
        this.hasSideEffects = hasSideEffects;
        this.supportsSoftLimiting = supportsSoftLimiting;
    }

    @Override
    protected void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    AppendableExpression appendString(Expression exp) {
        return this.withNewDelegate(this.delegate.invoke(APPEND, exp), true);
    }

    AppendableExpression appendChar(Expression exp) {
        return this.withNewDelegate(this.delegate.invoke(APPEND_CHAR, exp), true);
    }

    Expression softLimitReached() {
        Preconditions.checkArgument((boolean)this.supportsSoftLimiting);
        return this.delegate.invoke(SOFT_LIMITED, new Expression[0]);
    }

    AppendableExpression enterLoggableElement(Expression logStatement) {
        return this.withNewDelegate(this.delegate.invoke(ENTER_LOGGABLE_STATEMENT, logStatement), true);
    }

    AppendableExpression exitLoggableElement() {
        return this.withNewDelegate(this.delegate.invoke(EXIT_LOGGABLE_STATEMENT, new Expression[0]), true);
    }

    AppendableExpression appendLoggingFunctionInvocation(String functionName, String placeholderValue, List<SoyExpression> args, List<Expression> escapingDirectives) {
        return this.withNewDelegate(this.delegate.invoke(APPEND_LOGGING_FUNCTION_INVOCATION, LOGGING_FUNCTION_INVOCATION_CREATE.invoke(BytecodeUtils.constant(functionName), BytecodeUtils.constant(placeholderValue), SoyExpression.asBoxedList(args)), BytecodeUtils.asImmutableList(escapingDirectives)), true);
    }

    AppendableExpression setSanitizedContentKind(SanitizedContentKind kind) {
        return this.withNewDelegate(this.delegate.invoke(SET_SANITIZED_CONTENT_KIND, BytecodeUtils.constantSanitizedContentKindAsContentKind(kind)), true);
    }

    AppendableExpression setSanitizedContentDirectionality(Dir contentDir) {
        return this.withNewDelegate(this.delegate.invoke(SET_SANITIZED_CONTENT_DIRECTIONALITY, BytecodeUtils.constant(contentDir)), true);
    }

    @Override
    public AppendableExpression labelStart(Label label) {
        return this.withNewDelegate(this.delegate.labelStart(label), this.hasSideEffects);
    }

    @Override
    public Statement toStatement() {
        if (this.hasSideEffects) {
            return super.toStatement();
        }
        return Statement.NULL_STATEMENT;
    }

    private AppendableExpression withNewDelegate(Expression newDelegate, boolean hasSideEffects) {
        return new AppendableExpression(newDelegate, hasSideEffects, this.supportsSoftLimiting);
    }

    boolean supportsSoftLimiting() {
        return this.supportsSoftLimiting;
    }
}

