/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.proto;

import com.google.common.base.Preconditions;
import com.google.errorprone.annotations.ForOverride;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.template.soy.internal.proto.ProtoUtils;
import java.util.List;

public abstract class FieldVisitor<T> {
    public static <T> T visitField(Descriptors.FieldDescriptor fieldDescriptor, FieldVisitor<T> visitor) {
        if (fieldDescriptor.isMapField()) {
            List mapFields = fieldDescriptor.getMessageType().getFields();
            Preconditions.checkState((mapFields.size() == 2 ? 1 : 0) != 0, (Object)"proto representation of map fields changed");
            Descriptors.FieldDescriptor keyField = (Descriptors.FieldDescriptor)mapFields.get(0);
            Descriptors.FieldDescriptor valueField = (Descriptors.FieldDescriptor)mapFields.get(1);
            return visitor.visitMap(fieldDescriptor, FieldVisitor.getScalarType(keyField, visitor), FieldVisitor.getScalarType(valueField, visitor));
        }
        if (fieldDescriptor.isRepeated()) {
            return visitor.visitRepeated(FieldVisitor.getScalarType(fieldDescriptor, visitor));
        }
        return FieldVisitor.getScalarType(fieldDescriptor, visitor);
    }

    @ForOverride
    protected abstract T visitMap(Descriptors.FieldDescriptor var1, T var2, T var3);

    @ForOverride
    protected abstract T visitRepeated(T var1);

    @ForOverride
    protected abstract T visitLongAsInt();

    @ForOverride
    protected abstract T visitUnsignedInt();

    @ForOverride
    protected abstract T visitUnsignedLongAsString();

    @ForOverride
    protected abstract T visitLongAsString();

    @ForOverride
    protected abstract T visitBool();

    @ForOverride
    protected abstract T visitInt();

    @ForOverride
    protected abstract T visitBytes();

    @ForOverride
    protected abstract T visitString();

    @ForOverride
    protected abstract T visitDoubleAsFloat();

    @ForOverride
    protected abstract T visitFloat();

    @ForOverride
    protected abstract T visitSafeHtml();

    @ForOverride
    protected abstract T visitSafeScript();

    @ForOverride
    protected abstract T visitSafeStyle();

    @ForOverride
    protected abstract T visitSafeStyleSheet();

    @ForOverride
    protected abstract T visitSafeUrl();

    @ForOverride
    protected abstract T visitTrustedResourceUrl();

    @ForOverride
    protected abstract T visitMessage(Descriptors.Descriptor var1);

    @ForOverride
    protected abstract T visitEnum(Descriptors.EnumDescriptor var1);

    private static <T> T getScalarType(Descriptors.FieldDescriptor fieldDescriptor, FieldVisitor<T> visitor) {
        if (ProtoUtils.hasJsType(fieldDescriptor)) {
            DescriptorProtos.FieldOptions.JSType jsType = ProtoUtils.getJsType(fieldDescriptor);
            switch (jsType) {
                case JS_NORMAL: 
                case JS_NUMBER: {
                    return visitor.visitLongAsInt();
                }
                case JS_STRING: {
                    if (ProtoUtils.isUnsigned(fieldDescriptor)) {
                        return visitor.visitUnsignedLongAsString();
                    }
                    return visitor.visitLongAsString();
                }
            }
        }
        switch (fieldDescriptor.getType()) {
            case BOOL: {
                return visitor.visitBool();
            }
            case DOUBLE: {
                return visitor.visitDoubleAsFloat();
            }
            case FLOAT: {
                return visitor.visitFloat();
            }
            case BYTES: {
                return visitor.visitBytes();
            }
            case GROUP: {
                throw new UnsupportedOperationException("soy doesn't support proto groups: " + fieldDescriptor.getFullName());
            }
            case INT64: {
                return visitor.visitLongAsInt();
            }
            case INT32: 
            case SINT32: 
            case SFIXED32: {
                return visitor.visitInt();
            }
            case UINT32: 
            case FIXED32: {
                return visitor.visitUnsignedInt();
            }
            case FIXED64: 
            case SINT64: 
            case SFIXED64: 
            case UINT64: {
                throw new IllegalArgumentException("Cannot access " + fieldDescriptor.getFullName() + ": 64-bit integer types are not supported.  Consider, adding [(jspb.jstype) = INT52] or [(jspb.jstype) = STRING] to the field.");
            }
            case ENUM: {
                return visitor.visitEnum(fieldDescriptor.getEnumType());
            }
            case MESSAGE: {
                switch (fieldDescriptor.getMessageType().getFullName()) {
                    case "webutil.html.types.SafeHtmlProto": {
                        return visitor.visitSafeHtml();
                    }
                    case "webutil.html.types.SafeScriptProto": {
                        return visitor.visitSafeScript();
                    }
                    case "webutil.html.types.SafeStyleProto": {
                        return visitor.visitSafeStyle();
                    }
                    case "webutil.html.types.SafeStyleSheetProto": {
                        return visitor.visitSafeStyleSheet();
                    }
                    case "webutil.html.types.SafeUrlProto": {
                        return visitor.visitSafeUrl();
                    }
                    case "webutil.html.types.TrustedResourceUrlProto": {
                        return visitor.visitTrustedResourceUrl();
                    }
                }
                return visitor.visitMessage(fieldDescriptor.getMessageType());
            }
            case STRING: {
                return visitor.visitString();
            }
        }
        throw new AssertionError((Object)"Unexpected field type in proto");
    }
}

