/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.incrementaldomsrc;

import com.google.template.soy.internal.base.UnescapeUtils;
import com.google.template.soy.soytree.HtmlContext;
import com.google.template.soy.soytree.MsgFallbackGroupNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;

final class UnescapingVisitor {
    UnescapingVisitor() {
    }

    static void unescapeRawTextInHtml(SoyNode node) {
        for (RawTextNode rawText : SoyTreeUtils.getAllNodesOfType(node, RawTextNode.class)) {
            UnescapingVisitor.maybeRewriteRawText(rawText);
        }
    }

    private static void maybeRewriteRawText(RawTextNode node) {
        MsgPlaceholderNode containingPlaceholder;
        if (node.getHtmlContext() != HtmlContext.HTML_PCDATA && node.getHtmlContext() != HtmlContext.HTML_NORMAL_ATTR_VALUE) {
            return;
        }
        MsgFallbackGroupNode containingMsg = node.getNearestAncestor(MsgFallbackGroupNode.class);
        if (!(containingMsg == null || (containingPlaceholder = node.getNearestAncestor(MsgPlaceholderNode.class)) != null && SoyTreeUtils.isDescendantOf(containingPlaceholder, containingMsg))) {
            return;
        }
        String unescaped = UnescapeUtils.unescapeHtml(node.getRawText());
        if (!unescaped.equals(node.getRawText())) {
            node.getParent().replaceChild(node, new RawTextNode(node.getId(), unescaped, node.getSourceLocation(), node.getHtmlContext()));
        }
    }
}

