/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Equivalence;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;

public final class ExprEquivalence
extends Equivalence<ExprNode> {
    private static final ExprEquivalence INSTANCE = new ExprEquivalence();
    private final AbstractReturningExprNodeVisitor<Integer> hashCodeVisitor = new AbstractReturningExprNodeVisitor<Integer>(){

        @Override
        protected Integer visitVarRefNode(VarRefNode node) {
            return Objects.hashCode(node.getDefnDecl());
        }

        @Override
        protected Integer visitFieldAccessNode(FieldAccessNode node) {
            return Objects.hash(ExprEquivalence.this.wrap(node.getBaseExprChild()), node.getFieldName(), node.isNullSafe());
        }

        @Override
        protected Integer visitItemAccessNode(ItemAccessNode node) {
            return Objects.hash(ExprEquivalence.this.wrap(node.getBaseExprChild()), ExprEquivalence.this.wrap(node.getKeyExprChild()), node.isNullSafe());
        }

        @Override
        protected Integer visitFunctionNode(FunctionNode node) {
            return Objects.hash(ExprEquivalence.this.pairwise().wrap(node.getChildren()), node.getFunctionName());
        }

        @Override
        protected Integer visitGlobalNode(GlobalNode node) {
            return node.getName().hashCode();
        }

        @Override
        protected Integer visitListLiteralNode(ListLiteralNode node) {
            return this.hashChildren(node);
        }

        @Override
        protected Integer visitRecordLiteralNode(RecordLiteralNode node) {
            return ExprEquivalence.this.recordLiteralFields(node).hashCode();
        }

        @Override
        protected Integer visitMapLiteralNode(MapLiteralNode node) {
            return ExprEquivalence.this.mapLiteralFields(node).hashCode();
        }

        @Override
        protected Integer visitProtoInitNode(ProtoInitNode node) {
            return Objects.hash(node.getProtoName(), ExprEquivalence.this.protoInitFields(node));
        }

        @Override
        protected Integer visitBooleanNode(BooleanNode node) {
            return Boolean.valueOf(node.getValue()).hashCode();
        }

        @Override
        protected Integer visitIntegerNode(IntegerNode node) {
            return Longs.hashCode((long)node.getValue());
        }

        @Override
        protected Integer visitFloatNode(FloatNode node) {
            return Doubles.hashCode((double)node.getValue());
        }

        @Override
        protected Integer visitStringNode(StringNode node) {
            return node.getValue().hashCode();
        }

        @Override
        protected Integer visitExprRootNode(ExprRootNode node) {
            return this.hashChildren(node);
        }

        @Override
        protected Integer visitOperatorNode(ExprNode.OperatorNode node) {
            return node.getOperator().hashCode() * 31 + this.hashChildren(node);
        }

        @Override
        protected Integer visitNullNode(NullNode node) {
            return 0;
        }

        @Override
        protected Integer visitExprNode(ExprNode node) {
            throw new UnsupportedOperationException(node.toSourceString());
        }

        private int hashChildren(ExprNode.ParentExprNode node) {
            return ExprEquivalence.this.pairwise().hash(node.getChildren());
        }
    };

    public static ExprEquivalence get() {
        return INSTANCE;
    }

    private final HashMap<String, Equivalence.Wrapper<ExprNode>> protoInitFields(ProtoInitNode node) {
        HashMap<String, Equivalence.Wrapper<ExprNode>> map = new HashMap<String, Equivalence.Wrapper<ExprNode>>();
        List<ExprNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            map.put(node.getParamName(i).identifier(), (Equivalence.Wrapper<ExprNode>)this.wrap(children.get(i)));
        }
        return map;
    }

    private final HashMap<String, Equivalence.Wrapper<ExprNode>> recordLiteralFields(RecordLiteralNode node) {
        HashMap<String, Equivalence.Wrapper<ExprNode>> map = new HashMap<String, Equivalence.Wrapper<ExprNode>>();
        List<ExprNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            map.put(node.getKey(i).identifier(), (Equivalence.Wrapper<ExprNode>)this.wrap(children.get(i)));
        }
        return map;
    }

    private final HashMap<Equivalence.Wrapper<ExprNode>, Equivalence.Wrapper<ExprNode>> mapLiteralFields(MapLiteralNode node) {
        HashMap<Equivalence.Wrapper<ExprNode>, Equivalence.Wrapper<ExprNode>> map = new HashMap<Equivalence.Wrapper<ExprNode>, Equivalence.Wrapper<ExprNode>>();
        List<ExprNode> children = node.getChildren();
        for (int i = 0; i < children.size(); i += 2) {
            map.put((Equivalence.Wrapper<ExprNode>)this.wrap(children.get(i)), (Equivalence.Wrapper<ExprNode>)this.wrap(children.get(i + 1)));
        }
        return map;
    }

    private ExprEquivalence() {
    }

    protected boolean doEquivalent(ExprNode a, ExprNode b) {
        return a.getKind() == b.getKind() && (Boolean)new EqualsVisitor(a).exec(b) != false;
    }

    protected int doHash(ExprNode t) {
        return 31 * t.getKind().hashCode() + (Integer)this.hashCodeVisitor.exec(t);
    }

    final class EqualsVisitor
    extends AbstractReturningExprNodeVisitor<Boolean> {
        private final ExprNode other;

        EqualsVisitor(ExprNode other) {
            this.other = other;
        }

        @Override
        protected Boolean visitVarRefNode(VarRefNode node) {
            VarRefNode typedOther = (VarRefNode)this.other;
            if (node.getDefnDecl() != null || typedOther.getDefnDecl() != null) {
                return typedOther.getDefnDecl() == node.getDefnDecl();
            }
            return typedOther.getName().equals(node.getName());
        }

        @Override
        protected Boolean visitFieldAccessNode(FieldAccessNode node) {
            FieldAccessNode typedOther = (FieldAccessNode)this.other;
            return ExprEquivalence.this.equivalent(node.getBaseExprChild(), typedOther.getBaseExprChild()) && node.getFieldName().equals(typedOther.getFieldName()) && node.isNullSafe() == typedOther.isNullSafe();
        }

        @Override
        protected Boolean visitItemAccessNode(ItemAccessNode node) {
            ItemAccessNode typedOther = (ItemAccessNode)this.other;
            return ExprEquivalence.this.equivalent(node.getBaseExprChild(), typedOther.getBaseExprChild()) && ExprEquivalence.this.equivalent(node.getKeyExprChild(), typedOther.getKeyExprChild()) && node.isNullSafe() == typedOther.isNullSafe();
        }

        @Override
        protected Boolean visitFunctionNode(FunctionNode node) {
            FunctionNode typedOther = (FunctionNode)this.other;
            return node.getFunctionName().equals(typedOther.getFunctionName()) && this.compareChildren(node);
        }

        @Override
        protected Boolean visitGlobalNode(GlobalNode node) {
            return node.getName().equals(((GlobalNode)this.other).getName());
        }

        @Override
        protected Boolean visitListLiteralNode(ListLiteralNode node) {
            return this.compareChildren(node);
        }

        @Override
        protected Boolean visitRecordLiteralNode(RecordLiteralNode node) {
            return ExprEquivalence.this.recordLiteralFields(node).equals(ExprEquivalence.this.recordLiteralFields((RecordLiteralNode)this.other));
        }

        @Override
        protected Boolean visitMapLiteralNode(MapLiteralNode node) {
            return ExprEquivalence.this.mapLiteralFields(node).equals(ExprEquivalence.this.mapLiteralFields((MapLiteralNode)this.other));
        }

        @Override
        protected Boolean visitProtoInitNode(ProtoInitNode node) {
            ProtoInitNode otherNode = (ProtoInitNode)this.other;
            if (!otherNode.getProtoName().equals(node.getProtoName())) {
                return false;
            }
            return ExprEquivalence.this.protoInitFields(node).equals(ExprEquivalence.this.protoInitFields(otherNode));
        }

        @Override
        protected Boolean visitBooleanNode(BooleanNode node) {
            return node.getValue() == ((BooleanNode)this.other).getValue();
        }

        @Override
        protected Boolean visitIntegerNode(IntegerNode node) {
            return node.getValue() == ((IntegerNode)this.other).getValue();
        }

        @Override
        protected Boolean visitFloatNode(FloatNode node) {
            return node.getValue() == ((FloatNode)this.other).getValue();
        }

        @Override
        protected Boolean visitStringNode(StringNode node) {
            return node.getValue().equals(((StringNode)this.other).getValue());
        }

        @Override
        protected Boolean visitExprRootNode(ExprRootNode node) {
            return this.compareChildren(node);
        }

        @Override
        protected Boolean visitOperatorNode(ExprNode.OperatorNode node) {
            return node.getOperator() == ((ExprNode.OperatorNode)this.other).getOperator() && this.compareChildren(node);
        }

        @Override
        protected Boolean visitNullNode(NullNode node) {
            return true;
        }

        @Override
        protected Boolean visitExprNode(ExprNode node) {
            throw new UnsupportedOperationException(node.toSourceString());
        }

        private boolean compareChildren(ExprNode.ParentExprNode node) {
            return ExprEquivalence.this.pairwise().equivalent(node.getChildren(), ((ExprNode.ParentExprNode)this.other).getChildren());
        }
    }
}

