/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.restricted;

import com.google.errorprone.annotations.Immutable;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.restricted.PrimitiveData;
import com.google.template.soy.data.restricted.SoyString;
import java.io.IOException;

@Immutable
public final class StringData
extends PrimitiveData
implements SoyString {
    public static final StringData EMPTY_STRING = new StringData("");
    private final String value;

    private StringData(String value) {
        this.value = value;
    }

    public static StringData forValue(String value) {
        return value.length() == 0 ? EMPTY_STRING : new StringData(value);
    }

    public String getValue() {
        return this.value;
    }

    @Override
    public String stringValue() {
        return this.getValue();
    }

    public String toString() {
        return this.getValue();
    }

    @Override
    public boolean coerceToBoolean() {
        return this.getValue().length() > 0;
    }

    @Override
    public String coerceToString() {
        return this.toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append(this.value);
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getValue().equals(other.toString());
    }

    @Override
    public int hashCode() {
        return this.stringValue().hashCode();
    }
}

