/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.Transforms;
import com.google.template.soy.data.restricted.StringData;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public final class DictImpl
extends SoyAbstractValue
implements SoyDict,
SoyMap {
    private final Map<String, ? extends SoyValueProvider> providerMap;
    private final RuntimeMapTypeTracker typeTracker;

    public static DictImpl forProviderMap(Map<String, ? extends SoyValueProvider> providerMap, RuntimeMapTypeTracker.Type mapType) {
        return new DictImpl(providerMap, mapType);
    }

    private DictImpl(Map<String, ? extends SoyValueProvider> providerMap, RuntimeMapTypeTracker.Type typeTracker) {
        this.providerMap = (Map)Preconditions.checkNotNull(providerMap);
        this.typeTracker = new RuntimeMapTypeTracker((RuntimeMapTypeTracker.Type)((Object)Preconditions.checkNotNull((Object)((Object)typeTracker))));
    }

    @Override
    public final boolean hasField(String name) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.containsKey(name);
    }

    @Override
    public final SoyValue getField(String name) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.getFieldInternal(name);
    }

    private SoyValue getFieldInternal(String name) {
        SoyValueProvider provider = this.providerMap.get(name);
        return provider != null ? provider.resolve() : null;
    }

    @Override
    public final SoyValueProvider getFieldProvider(String name) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.get(name);
    }

    @Override
    public final int getItemCnt() {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.size();
    }

    @Override
    public int size() {
        this.typeTracker.maybeSetMapType();
        return this.providerMap.size();
    }

    @Override
    @Nonnull
    public final Iterable<? extends SoyValue> getItemKeys() {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return Iterables.transform(this.providerMap.keySet(), StringData::forValue);
    }

    @Override
    @Nonnull
    public Iterable<? extends SoyValue> keys() {
        this.typeTracker.maybeSetMapType();
        return Iterables.transform(this.providerMap.keySet(), StringData::forValue);
    }

    @Override
    public final boolean hasItem(SoyValue key) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.containsKey(this.getStringKey(key));
    }

    @Override
    public boolean containsKey(SoyValue key) {
        this.typeTracker.maybeSetMapType();
        return this.providerMap.containsKey(this.getStringKey(key));
    }

    @Override
    public final SoyValue getItem(SoyValue key) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.getFieldInternal(this.getStringKey(key));
    }

    @Override
    public SoyValue get(SoyValue key) {
        this.typeTracker.maybeSetMapType();
        return this.getFieldInternal(this.getStringKey(key));
    }

    @Override
    public final SoyValueProvider getItemProvider(SoyValue key) {
        this.typeTracker.maybeSetLegacyObjectMapOrRecordType();
        return this.providerMap.get(this.getStringKey(key));
    }

    @Override
    public SoyValueProvider getProvider(SoyValue key) {
        this.typeTracker.maybeSetMapType();
        return this.providerMap.get(this.getStringKey(key));
    }

    @Override
    @Nonnull
    public final Map<String, ? extends SoyValueProvider> asJavaStringMap() {
        return Collections.unmodifiableMap(this.providerMap);
    }

    @Override
    @Nonnull
    public final Map<String, ? extends SoyValue> asResolvedJavaStringMap() {
        return Maps.transformValues(this.asJavaStringMap(), Transforms.RESOLVE_FUNCTION);
    }

    @Override
    @Nonnull
    public Map<? extends SoyValue, ? extends SoyValueProvider> asJavaMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, ? extends SoyValueProvider> entry : this.providerMap.entrySet()) {
            builder.put((Object)StringData.forValue(entry.getKey()), (Object)entry.getValue());
        }
        return builder.build();
    }

    private String getStringKey(SoyValue key) {
        try {
            return key.stringValue();
        }
        catch (SoyDataException e) {
            throw new SoyDataException("SoyDict accessed with non-string key (got key type " + key.getClass().getName() + ").");
        }
    }

    @Override
    public final boolean coerceToBoolean() {
        return true;
    }

    @Override
    public final String coerceToString() {
        LoggingAdvisingAppendable.BufferingAppendable mapStr = LoggingAdvisingAppendable.buffering();
        try {
            this.render(mapStr);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
        return ((Object)mapStr).toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        appendable.append('{');
        boolean isFirst = true;
        boolean useNewSoyMap = this.typeTracker.type() == RuntimeMapTypeTracker.Type.MAP;
        for (SoyValue soyValue : useNewSoyMap ? this.keys() : this.getItemKeys()) {
            SoyValue value;
            SoyValue soyValue2 = value = useNewSoyMap ? this.get(soyValue) : this.getItem(soyValue);
            if (isFirst) {
                isFirst = false;
            } else {
                appendable.append(", ");
            }
            soyValue.render(appendable);
            appendable.append(": ");
            value.render(appendable);
        }
        appendable.append('}');
    }

    @Override
    public final boolean equals(Object other) {
        return this == other;
    }

    @Override
    public final int hashCode() {
        return System.identityHashCode(this);
    }

    public String toString() {
        return this.coerceToString();
    }

    public RuntimeMapTypeTracker.Type getMapType() {
        return this.typeTracker.type();
    }
}

