/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.Collection;

final class BannedHtmlTag
extends Rule<HtmlOpenTagNode> {
    private final ImmutableSet<String> bannedTagNames;
    private final ImmutableSet<String> bannedPossiblyPresentAttributes;

    BannedHtmlTag(Collection<String> bannedTagNames, Collection<String> bannedPossiblyPresentAttributes, SoyErrorKind error) {
        super(error);
        this.bannedTagNames = (ImmutableSet)bannedTagNames.stream().map(tagName -> Ascii.toLowerCase((String)tagName)).collect(ImmutableSet.toImmutableSet());
        this.bannedPossiblyPresentAttributes = (ImmutableSet)bannedPossiblyPresentAttributes.stream().map(attrName -> Ascii.toLowerCase((String)attrName)).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    protected void doCheckConformance(HtmlOpenTagNode node, ErrorReporter errorReporter) {
        if (this.isBannedTag(node) && (this.bannedPossiblyPresentAttributes.isEmpty() || this.hasBannedAttributes(node))) {
            errorReporter.report(node.getSourceLocation(), this.error, new Object[0]);
        }
    }

    private boolean isBannedTag(HtmlOpenTagNode node) {
        return node.getTagName().isStatic() && this.bannedTagNames.contains((Object)node.getTagName().getStaticTagNameAsLowerCase());
    }

    private boolean hasBannedAttributes(HtmlOpenTagNode node) {
        return this.bannedPossiblyPresentAttributes.stream().allMatch(bannedAttrName -> SoyTreeUtils.getAllNodesOfType(node, HtmlAttributeNode.class).stream().anyMatch(attr -> attr.definitelyMatchesAttributeName((String)bannedAttrName)));
    }
}

