/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.plugin.java.restricted.JavaPluginContext;
import com.google.template.soy.plugin.java.restricted.JavaValue;
import com.google.template.soy.plugin.java.restricted.JavaValueFactory;
import com.google.template.soy.plugin.java.restricted.SoyJavaSourceFunction;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptPluginContext;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValue;
import com.google.template.soy.plugin.javascript.restricted.JavaScriptValueFactory;
import com.google.template.soy.plugin.javascript.restricted.SoyJavaScriptSourceFunction;
import com.google.template.soy.plugin.python.restricted.PythonPluginContext;
import com.google.template.soy.plugin.python.restricted.PythonValue;
import com.google.template.soy.plugin.python.restricted.PythonValueFactory;
import com.google.template.soy.plugin.python.restricted.SoyPythonSourceFunction;
import com.google.template.soy.shared.restricted.Signature;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import java.lang.reflect.Method;
import java.util.List;

@SoyFunctionSignature(name="range", value={@Signature(parameterTypes={"number"}, returnType="list<int>"), @Signature(parameterTypes={"number", "number"}, returnType="list<int>"), @Signature(parameterTypes={"number", "number", "number"}, returnType="list<int>")})
public final class RangeFunction
implements SoyJavaSourceFunction,
SoyJavaScriptSourceFunction,
SoyPythonSourceFunction {
    @Override
    public JavaValue applyForJavaSource(JavaValueFactory factory, List<JavaValue> args, JavaPluginContext context) {
        JavaValue step;
        JavaValue end;
        JavaValue start;
        switch (args.size()) {
            case 1: {
                start = factory.constant(0L);
                end = args.get(0).asSoyInt();
                step = factory.constant(1L);
                break;
            }
            case 2: {
                start = args.get(0).asSoyInt();
                end = args.get(1).asSoyInt();
                step = factory.constant(1L);
                break;
            }
            case 3: {
                start = args.get(0).asSoyInt();
                end = args.get(1).asSoyInt();
                step = args.get(2).asSoyInt();
                break;
            }
            default: {
                throw new AssertionError();
            }
        }
        return factory.callStaticMethod(Methods.RANGE, start, end, step);
    }

    @Override
    public PythonValue applyForPythonSource(PythonValueFactory factory, List<PythonValue> args, PythonPluginContext context) {
        return factory.global("range").call(args.toArray(new PythonValue[0]));
    }

    @Override
    public JavaScriptValue applyForJavaScriptSource(JavaScriptValueFactory factory, List<JavaScriptValue> args, JavaScriptPluginContext context) {
        return factory.callNamespaceFunction("goog.array", "goog.array.range", args.toArray(new JavaScriptValue[0]));
    }

    private static final class Methods {
        static final Method RANGE = JavaValueFactory.createMethod(BasicFunctionsRuntime.class, "range", Integer.TYPE, Integer.TYPE, Integer.TYPE);

        private Methods() {
        }
    }
}

