/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.UnsanitizedString;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.internal.base.UnescapeUtils;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class HtmlToText {
    private static final Pattern TAG = Pattern.compile("<(?:!--.*?--|(?:!|(/?[a-z][\\w:-]*))(?:[^>'\"]|\"[^\"]*\"|'[^']*')*)>|\\z", 2);
    private static final Pattern REMOVING_TAGS = Pattern.compile("script|style|textarea|title", 2);
    private static final Pattern WS_PRESERVING_TAGS = Pattern.compile("pre", 2);
    private static final Pattern NEWLINE_TAGS = Pattern.compile("br", 2);
    private static final Pattern BLOCK_TAGS = Pattern.compile("/?(address|blockquote|dd|div|dl|dt|h[1-6]|hr|li|ol|p|pre|table|tr|ul)", 2);
    private static final Pattern TAB_TAGS = Pattern.compile("td|th", 2);
    private static final Pattern WHITESPACE = Pattern.compile("\\s+");
    private static final Pattern TRAILING_NON_WHITESPACE = Pattern.compile("\\S\\z");
    private static final Pattern TRAILING_NON_NEWLINE = Pattern.compile("[^\n]\\z");
    private static final Pattern LEADING_SPACE = Pattern.compile("^ ");

    public static String convert(SoyValue value) {
        if (value == null || value instanceof NullData) {
            return "";
        }
        if (!(value instanceof SanitizedContent) || value instanceof UnsanitizedString) {
            return value.stringValue();
        }
        Preconditions.checkArgument((((SanitizedContent)value).getContentKind() == SanitizedContent.ContentKind.HTML ? 1 : 0) != 0);
        String html = value.stringValue();
        StringBuilder text = new StringBuilder();
        int start = 0;
        String removingUntil = "";
        String wsPreservingUntil = "";
        Matcher matcher = TAG.matcher(html);
        while (matcher.find()) {
            int offset = matcher.start();
            String tag = matcher.group(1);
            if (removingUntil.isEmpty()) {
                String chunk = html.substring(start, offset);
                chunk = UnescapeUtils.unescapeHtml(chunk);
                if (wsPreservingUntil.isEmpty()) {
                    chunk = WHITESPACE.matcher(chunk).replaceAll(" ");
                    if (!TRAILING_NON_WHITESPACE.matcher(text).find()) {
                        chunk = LEADING_SPACE.matcher(chunk).replaceFirst("");
                    }
                }
                text.append(chunk);
                if (tag != null) {
                    if (REMOVING_TAGS.matcher(tag).matches()) {
                        removingUntil = '/' + tag;
                    } else if (NEWLINE_TAGS.matcher(tag).matches()) {
                        text.append('\n');
                    } else if (BLOCK_TAGS.matcher(tag).matches()) {
                        if (TRAILING_NON_NEWLINE.matcher(text).find()) {
                            text.append('\n');
                        }
                        if (WS_PRESERVING_TAGS.matcher(tag).matches()) {
                            wsPreservingUntil = '/' + tag;
                        } else if (Ascii.equalsIgnoreCase((CharSequence)tag, (CharSequence)wsPreservingUntil)) {
                            wsPreservingUntil = "";
                        }
                    } else if (TAB_TAGS.matcher(tag).matches()) {
                        text.append('\t');
                    }
                }
            } else if (Ascii.equalsIgnoreCase((CharSequence)removingUntil, (CharSequence)tag)) {
                removingUntil = "";
            }
            start = matcher.end();
        }
        return text.toString();
    }
}

