/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.template.soy.data.SoyDict;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyList;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyMaps;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class BasicFunctionsRuntime {
    public static SoyDict augmentMap(SoyValue sv1, SoyValue sv2) {
        SoyDict first = (SoyDict)sv1;
        SoyDict second = (SoyDict)sv2;
        HashMap map = Maps.newHashMapWithExpectedSize((int)(first.getItemCnt() + second.getItemCnt()));
        map.putAll(first.asJavaStringMap());
        map.putAll(second.asJavaStringMap());
        return DictImpl.forProviderMap(map, RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD);
    }

    public static long ceil(SoyValue arg) {
        if (arg instanceof IntegerData) {
            return ((IntegerData)arg).longValue();
        }
        return (long)Math.ceil(arg.floatValue());
    }

    public static List<SoyValueProvider> concatLists(List<SoyList> args) {
        ImmutableList.Builder flattened = ImmutableList.builder();
        for (SoyList soyList : args) {
            flattened.addAll(soyList.asJavaList());
        }
        return flattened.build();
    }

    public static boolean listContains(SoyList list, SoyValue value) {
        return list.asJavaList().contains(value);
    }

    public static String join(SoyList list, String separator) {
        ArrayList<String> stringList = new ArrayList<String>();
        for (SoyValue soyValue : list.asResolvedJavaList()) {
            stringList.add(soyValue.coerceToString());
        }
        return Joiner.on((String)separator).join(stringList);
    }

    public static long floor(SoyValue arg) {
        if (arg instanceof IntegerData) {
            return ((IntegerData)arg).longValue();
        }
        return (long)Math.floor(arg.floatValue());
    }

    public static List<SoyValue> keys(SoyValue sv) {
        SoyLegacyObjectMap map = (SoyLegacyObjectMap)sv;
        ArrayList<SoyValue> list = new ArrayList<SoyValue>(map.getItemCnt());
        Iterables.addAll(list, map.getItemKeys());
        return list;
    }

    public static List<SoyValue> mapKeys(SoyMap map) {
        return ImmutableList.copyOf(map.keys());
    }

    public static SoyDict mapToLegacyObjectMap(SoyMap map) {
        HashMap<String, SoyValueProvider> keysCoercedToStrings = new HashMap<String, SoyValueProvider>();
        for (Map.Entry<? extends SoyValue, ? extends SoyValueProvider> entry : map.asJavaMap().entrySet()) {
            keysCoercedToStrings.put(entry.getKey().coerceToString(), entry.getValue());
        }
        return DictImpl.forProviderMap(keysCoercedToStrings, RuntimeMapTypeTracker.Type.LEGACY_OBJECT_MAP_OR_RECORD);
    }

    public static NumberData max(SoyValue arg0, SoyValue arg1) {
        if (arg0 instanceof IntegerData && arg1 instanceof IntegerData) {
            return IntegerData.forValue(Math.max(arg0.longValue(), arg1.longValue()));
        }
        return FloatData.forValue(Math.max(arg0.numberValue(), arg1.numberValue()));
    }

    public static NumberData min(SoyValue arg0, SoyValue arg1) {
        if (arg0 instanceof IntegerData && arg1 instanceof IntegerData) {
            return IntegerData.forValue(Math.min(arg0.longValue(), arg1.longValue()));
        }
        return FloatData.forValue(Math.min(arg0.numberValue(), arg1.numberValue()));
    }

    public static FloatData parseFloat(String str) {
        Double d = Doubles.tryParse((String)str);
        return d == null || d.isNaN() ? null : FloatData.forValue(d);
    }

    public static IntegerData parseInt(String str) {
        Long l = Longs.tryParse((String)str);
        return l == null ? null : IntegerData.forValue(l);
    }

    public static long randomInt(long longValue) {
        return (long)Math.floor(Math.random() * (double)longValue);
    }

    public static NumberData round(SoyValue value, int numDigitsAfterPoint) {
        if (numDigitsAfterPoint == 0) {
            return IntegerData.forValue(BasicFunctionsRuntime.round(value));
        }
        if (numDigitsAfterPoint > 0) {
            double valueDouble = value.numberValue();
            double shift = Math.pow(10.0, numDigitsAfterPoint);
            return FloatData.forValue((double)Math.round(valueDouble * shift) / shift);
        }
        double valueDouble = value.numberValue();
        double shift = Math.pow(10.0, -numDigitsAfterPoint);
        return IntegerData.forValue((int)((double)Math.round(valueDouble / shift) * shift));
    }

    public static long round(SoyValue value) {
        if (value instanceof IntegerData) {
            return value.longValue();
        }
        return Math.round(value.numberValue());
    }

    public static List<IntegerData> range(int start, int end, int step) {
        if (step == 0) {
            throw new IllegalArgumentException(String.format("step must be non-zero: %d", step));
        }
        int length = end - start;
        if ((length ^ step) < 0) {
            return ImmutableList.of();
        }
        int size = length / step + (length % step == 0 ? 0 : 1);
        ArrayList<IntegerData> list = new ArrayList<IntegerData>(size);
        if (step > 0) {
            for (int i = start; i < end; i += step) {
                list.add(IntegerData.forValue(i));
            }
        } else {
            for (int i = start; i > end; i += step) {
                list.add(IntegerData.forValue(i));
            }
        }
        return list;
    }

    public static boolean strContains(SoyValue left, String right) {
        return left.stringValue().contains(right);
    }

    public static int strIndexOf(SoyValue left, SoyValue right) {
        return left.stringValue().indexOf(right.stringValue());
    }

    public static int strLen(SoyValue str) {
        return str.stringValue().length();
    }

    public static String strSub(SoyValue str, int start) {
        return str.stringValue().substring(start);
    }

    public static String strSub(SoyValue str, int start, int end) {
        return str.stringValue().substring(start, end);
    }

    public static int length(List<?> list) {
        return list.size();
    }

    public static SoyMap legacyObjectMapToMap(SoyValue value) {
        return SoyMaps.legacyObjectMapToMap((SoyLegacyObjectMap)value);
    }
}

