/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.CharMatcher;
import com.google.common.base.Preconditions;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multiset;
import java.util.HashSet;
import java.util.Set;

public final class UniqueNameGenerator {
    private final Set<String> reserved = new HashSet<String>();
    private final Multiset<String> names = HashMultiset.create();
    private final CharMatcher bannedCharacters;
    private final String collisionSeparator;

    public UniqueNameGenerator(CharMatcher bannedCharacters, String collisionSeparator) {
        Preconditions.checkArgument((boolean)bannedCharacters.matchesNoneOf((CharSequence)collisionSeparator), (String)"separator %s contains banned characters", (Object)collisionSeparator);
        this.bannedCharacters = bannedCharacters;
        this.collisionSeparator = collisionSeparator;
    }

    public void claimName(String name) {
        this.checkName(name);
        if (this.names.add((Object)name, 1) != 0) {
            this.names.remove((Object)name);
            if (this.reserved.contains(name)) {
                throw new IllegalArgumentException("Tried to claim a reserved name: " + name);
            }
            throw new IllegalArgumentException("Name: " + name + " was already claimed!");
        }
    }

    public void reserve(Iterable<String> names) {
        for (String name : names) {
            this.reserve(name);
        }
    }

    public void reserve(String name) {
        this.checkName(name);
        if (this.reserved.add(name) && !this.names.add((Object)name)) {
            this.names.remove((Object)name);
            throw new IllegalArgumentException("newly reserved name: " + name + " was already used!");
        }
    }

    public String generateName(String name) {
        this.checkName(name);
        this.names.add((Object)name);
        int count = this.names.count((Object)name);
        if (count == 1) {
            return name;
        }
        return name + this.collisionSeparator + (count - 1);
    }

    public boolean hasName(String name) {
        int separator = name.lastIndexOf(this.collisionSeparator);
        return this.names.contains((Object)(separator == -1 ? name : name.substring(0, separator)));
    }

    private void checkName(String name) {
        Preconditions.checkArgument((!name.isEmpty() ? 1 : 0) != 0);
        Preconditions.checkArgument((!name.contains(this.collisionSeparator) ? 1 : 0) != 0, (String)"%s contains the separation character: '%s'", (Object)name, (Object)this.collisionSeparator);
        Preconditions.checkArgument((!this.bannedCharacters.matchesAnyOf((CharSequence)name) ? 1 : 0) != 0, (String)"%s contains dangerous characters!", (Object)name);
    }
}

