/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.io.ByteSource;
import java.io.IOException;
import java.io.OutputStream;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;

public final class SoyJarFileWriter
implements AutoCloseable {
    private final DeterministicJarOutputStream stream;

    public SoyJarFileWriter(OutputStream stream) throws IOException {
        this.stream = new DeterministicJarOutputStream(stream);
    }

    public void writeEntry(String path, ByteSource contents) throws IOException {
        this.stream.putNextEntry(new ZipEntry(path));
        contents.copyTo((OutputStream)this.stream);
        this.stream.closeEntry();
    }

    @Override
    public void close() throws IOException {
        this.stream.close();
    }

    private static Manifest standardSoyJarManifest() {
        Manifest mf = new Manifest();
        mf.getMainAttributes().put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mf.getMainAttributes().put(new Attributes.Name("Created-By"), "soy");
        return mf;
    }

    private static final class DeterministicJarOutputStream
    extends JarOutputStream {
        DeterministicJarOutputStream(OutputStream outputStream) throws IOException {
            super(outputStream, SoyJarFileWriter.standardSoyJarManifest());
        }

        @Override
        public void putNextEntry(ZipEntry ze) throws IOException {
            ze.setTime(0L);
            super.putNextEntry(ze);
        }
    }
}

