/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.io.CharSource;
import com.google.common.io.Files;
import com.google.common.io.Resources;
import com.google.template.soy.base.internal.StableSoyFileSupplier;
import com.google.template.soy.base.internal.VolatileSoyFileSupplier;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

public interface SoyFileSupplier {
    public CharSource asCharSource();

    public Reader open() throws IOException;

    public boolean hasChangedSince(Version var1);

    public String getFilePath();

    public Version getVersion();

    public static final class Factory {
        public static SoyFileSupplier create(CharSource contentSource, String filePath) {
            return new StableSoyFileSupplier(contentSource, filePath);
        }

        public static SoyFileSupplier create(File inputFile) {
            return Factory.create(Files.asCharSource((File)inputFile, (Charset)StandardCharsets.UTF_8), inputFile.getPath());
        }

        public static SoyFileSupplier create(URL inputFileUrl, String filePath) {
            if (inputFileUrl.getProtocol().equals("file")) {
                URI inputFileUri;
                try {
                    inputFileUri = inputFileUrl.toURI();
                }
                catch (URISyntaxException ex) {
                    throw new RuntimeException(ex);
                }
                return new VolatileSoyFileSupplier(new File(inputFileUri));
            }
            return Factory.create(Resources.asCharSource((URL)inputFileUrl, (Charset)StandardCharsets.UTF_8), filePath);
        }

        public static SoyFileSupplier create(URL inputFileUrl) {
            return Factory.create(inputFileUrl, inputFileUrl.toString());
        }

        public static SoyFileSupplier create(CharSequence content, String filePath) {
            return Factory.create(CharSource.wrap((CharSequence)content), filePath);
        }

        private Factory() {
        }
    }

    public static interface Version {
        public static final Version STABLE_VERSION = new Version(){};

        public boolean equals(Object var1);
    }
}

