/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.base.internal;

import com.google.common.base.Ascii;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.util.Optional;
import java.util.TreeMap;

public enum SanitizedContentKind {
    HTML,
    JS,
    URI,
    TRUSTED_RESOURCE_URI,
    ATTRIBUTES,
    CSS,
    TEXT;

    private static final ImmutableMap<String, SanitizedContentKind> KINDS_BY_ATTRIBUTE_VALUE;
    private final String attributeValue = Ascii.toLowerCase((String)this.name());

    public String asAttributeValue() {
        return this.attributeValue;
    }

    public static Optional<SanitizedContentKind> fromAttributeValue(String attributeValue) {
        Preconditions.checkNotNull((Object)attributeValue);
        return Optional.ofNullable((SanitizedContentKind)((Object)KINDS_BY_ATTRIBUTE_VALUE.get((Object)attributeValue)));
    }

    public static ImmutableSet<String> attributeValues() {
        return KINDS_BY_ATTRIBUTE_VALUE.keySet();
    }

    static {
        TreeMap<String, SanitizedContentKind> kindsByAttributeValue = new TreeMap<String, SanitizedContentKind>();
        for (SanitizedContentKind kind : SanitizedContentKind.values()) {
            kindsByAttributeValue.put(kind.attributeValue, kind);
        }
        KINDS_BY_ATTRIBUTE_VALUE = ImmutableMap.copyOf(kindsByAttributeValue);
    }
}

